/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RaptorModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart bodyNeck;
    private final ModelPart head;
    private final ModelPart headBottom;
    private final ModelPart headTop;
    private final ModelPart leftArm;
    private final ModelPart leftLeg;
    private final ModelPart leftLegClaw;
    private final ModelPart rightArm;
    private final ModelPart rightLeg;
    private final ModelPart rightLegClaw;
    private final ModelPart tail;
    private final ModelPart tailEnd;
    private final ModelPart tailMiddle;

    public RaptorModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.bodyNeck = this.body.m_171324_("neck");
        this.head = root.m_171324_("head");
        this.headBottom = this.head.m_171324_("head_bottom");
        this.headTop = this.head.m_171324_("head_top");
        this.leftArm = root.m_171324_("left_arm");
        this.leftLeg = root.m_171324_("left_leg");
        this.leftLegClaw = this.leftLeg.m_171324_("left_claw");
        this.rightArm = root.m_171324_("right_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.rightLegClaw = this.rightLeg.m_171324_("right_claw");
        this.tail = this.body.m_171324_("tail");
        this.tailMiddle = this.tail.m_171324_("tail_middle");
        this.tailEnd = this.tailMiddle.m_171324_("tail_end");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.75f, (float)-14.4f));
        head.m_171599_("head_top", CubeListBuilder.m_171558_().m_171514_(38, 0).m_171488_(-1.5f, -1.5f, -8.425f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.2f)).m_171514_(0, 35).m_171488_(-2.0f, -1.5f, -4.075f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.2f)).m_171514_(0, 27).m_171488_(-1.5f, 1.5f, -8.425f, 3.0f, 1.0f, 7.0f, new CubeDeformation(-0.21f)), PartPose.m_171419_((float)0.0f, (float)0.275f, (float)-1.025f));
        head.m_171599_("head_bottom", CubeListBuilder.m_171558_().m_171514_(46, 7).m_171488_(-1.0f, -0.501f, -7.7625f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.3f)).m_171514_(0, 43).m_171488_(-1.5f, -0.4f, -3.0625f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.4f)).m_171514_(35, 11).m_171488_(-1.0f, -1.6f, -7.6375f, 2.0f, 1.0f, 7.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)2.75f, (float)-1.5875f));
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 15).m_171488_(-2.5f, -15.0f, -9.0f, 5.0f, 7.0f, 5.0f, new CubeDeformation(-0.2f)).m_171514_(0, 0).m_171488_(-2.5f, -15.0f, -5.0f, 5.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-2.0f, -14.75f, 2.0f, 4.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-15.025f, (float)-9.35f));
        neck.m_171599_("neck_r1", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-2.0f, -2.225f, -0.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.201f)), PartPose.m_171423_((float)0.0f, (float)5.025f, (float)-0.15f, (float)0.7854f, (float)0.0f, (float)0.0f));
        neck.m_171599_("neck_r2", CubeListBuilder.m_171558_().m_171514_(34, 33).m_171488_(-2.0f, -3.975f, -3.3f, 4.0f, 7.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        neck.m_171599_("neck_r3", CubeListBuilder.m_171558_().m_171514_(36, 23).m_171488_(-2.0f, -4.925f, -2.225f, 4.0f, 6.0f, 4.0f, new CubeDeformation(-0.201f)), PartPose.m_171423_((float)0.0f, (float)-3.1749f, (float)-2.7222f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(20, 27).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)7.5f));
        PartDefinition tailMiddle = tail.m_171599_("tail_middle", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.0f, -1.25f, 0.0f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        tailMiddle.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(11, 36).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        PartDefinition leftArm = partDefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(11, 45).m_171488_(-1.0f, -1.6667f, -1.9333f, 2.0f, 5.0f, 3.0f, new CubeDeformation(-0.3f)).m_171514_(13, 27).m_171488_(-1.0f, 1.3333f, -5.3333f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)2.75f, (float)15.4167f, (float)-6.0667f, (float)0.3927f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("left_hand", CubeListBuilder.m_171558_().m_171514_(26, 11).m_171488_(1.75f, -7.25f, -11.8f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(0, 15).m_171488_(1.75f, -7.25f, -12.2f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)), PartPose.m_171419_((float)-2.75f, (float)8.5833f, (float)6.0667f));
        PartDefinition rightArm = partDefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(13, 27).m_171480_().m_171488_(-1.0f, 1.3333f, -5.3333f, 2.0f, 2.0f, 4.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(11, 45).m_171480_().m_171488_(-1.0f, -1.6667f, -1.9333f, 2.0f, 5.0f, 3.0f, new CubeDeformation(-0.3f)).m_171555_(false), PartPose.m_171423_((float)-2.75f, (float)15.4167f, (float)-6.0667f, (float)0.3927f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("right_hand", CubeListBuilder.m_171558_().m_171514_(26, 11).m_171480_().m_171488_(-3.75f, -7.25f, -11.8f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(0, 15).m_171480_().m_171488_(-3.75f, -7.25f, -12.2f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false), PartPose.m_171419_((float)2.75f, (float)8.5833f, (float)6.0667f));
        PartDefinition rightLeg = partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(27, 41).m_171480_().m_171488_(-1.0f, -1.4932f, -1.7312f, 2.0f, 8.0f, 3.0f, new CubeDeformation(-0.1f)).m_171555_(false).m_171514_(14, 15).m_171480_().m_171488_(-1.0f, 10.2068f, -2.2562f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)12.7932f, (float)0.2562f));
        rightLeg.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.0f, -2.5f, -0.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.3f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)8.7068f, (float)-0.0062f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        rightLeg.m_171599_("right_leg_r2", CubeListBuilder.m_171558_().m_171514_(37, 44).m_171480_().m_171488_(-1.0f, -2.0f, -1.625f, 2.0f, 3.0f, 4.0f, new CubeDeformation(-0.2f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)6.2068f, (float)-0.0062f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightClaw = rightLeg.m_171599_("right_claw", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171480_().m_171488_(-0.5f, -1.3295f, -0.4692f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)10.0134f, (float)-0.9849f, (float)0.3927f, (float)0.0f, (float)0.0f));
        rightClaw.m_171599_("right_claw_top_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171480_().m_171488_(-0.5f, -0.312f, -0.8371f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.101f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.8306f, (float)-0.4692f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(27, 41).m_171488_(-1.0f, -1.4932f, -1.7312f, 2.0f, 8.0f, 3.0f, new CubeDeformation(-0.1f)).m_171514_(14, 15).m_171488_(-1.0f, 10.2068f, -2.2562f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)12.7932f, (float)0.2562f));
        leftLeg.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.5f, -0.5f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.0f, (float)8.7068f, (float)-0.0062f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        leftLeg.m_171599_("left_leg_r2", CubeListBuilder.m_171558_().m_171514_(37, 44).m_171488_(-1.0f, -2.0f, -1.625f, 2.0f, 3.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)6.2068f, (float)-0.0062f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftClaw = leftLeg.m_171599_("left_claw", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-0.5f, -1.3295f, -0.4692f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)-1.0f, (float)10.0134f, (float)-0.9849f, (float)0.3927f, (float)0.0f, (float)0.0f));
        leftClaw.m_171599_("left_claw_top_r1", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-0.5f, -0.312f, -0.8371f, 1.0f, 1.0f, 2.0f, new CubeDeformation(-0.101f)), PartPose.m_171423_((float)0.0f, (float)-1.8306f, (float)-0.4692f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.body.m_104227_(0.0f, 32.0f, 0.0f);
            this.bodyNeck.f_104203_ = 0.4f;
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 14.0f, -10.0f);
            } else {
                this.head.m_104227_(0.0f, 12.75f, -15.4f);
            }
            this.head.f_104203_ = -0.4f;
            this.headBottom.f_104203_ = 0.0f;
            this.rightArm.m_104227_(-2.75f, 23.4167f, -6.0667f);
            this.rightArm.f_104203_ = -1.28f;
            this.leftArm.m_104227_(2.75f, 23.4167f, -6.0667f);
            this.leftArm.f_104203_ = -1.28f;
            this.rightLeg.m_104227_(-2.5f, 20.7932f, 0.2562f);
            this.rightLeg.f_104203_ = 1.58f;
            this.leftLeg.m_104227_(2.5f, 20.7932f, 0.2562f);
            this.leftLeg.f_104203_ = 1.58f;
        } else {
            this.body.m_104227_(0.0f, 24.0f, 0.0f);
            this.bodyNeck.f_104203_ = 0.0f;
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 8.75f, -9.0f);
            } else {
                this.head.m_104227_(0.0f, 2.75f, -14.4f);
            }
            this.head.f_104203_ = 0.0f;
            if ((double)limbSwingAmount > 0.01) {
                this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount * 0.5f;
                this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount * 0.5f;
            } else {
                this.rightArm.m_104227_(-2.75f, 15.4167f, -6.0667f);
                this.rightArm.m_171327_(0.1927f, 0.0f, 0.0f);
                this.leftArm.m_104227_(2.75f, 15.4167f, -6.0667f);
                this.leftArm.m_171327_(-0.3927f, 0.0f, 0.0f);
            }
            this.rightLeg.m_104227_(-2.5f, 12.7932f, 0.2562f);
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.leftLeg.m_104227_(2.5f, 12.7932f, 0.2562f);
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            this.rightLegClaw.f_104203_ = headPitch * ((float)Math.PI / 180) * -7.5f;
            this.leftLegClaw.f_104203_ = netHeadYaw * ((float)Math.PI / 180) * -0.5f;
        }
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) * -1.0f;
        float headBottomRotation = netHeadYaw * ((float)Math.PI / 180);
        if (headBottomRotation >= 0.0f) {
            this.headBottom.f_104203_ = headBottomRotation * (entity.m_5448_() == null ? 0.75f : 0.25f);
        }
        this.headTop.f_104203_ = headPitch * ((float)Math.PI / 360) * 0.5f;
        float tailSwing = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount * 0.75f;
        this.tail.f_104203_ = tailSwing * 0.5f;
        this.tail.f_104204_ = tailSwing;
        this.tailMiddle.f_104204_ = tailSwing;
        this.tailEnd.f_104204_ = tailSwing;
        if (this.tail.f_104203_ == 0.0f) {
            float tailSwingAlternative;
            this.tail.f_104204_ = tailSwingAlternative = netHeadYaw * ((float)Math.PI / 180) * 0.5f;
            this.tailMiddle.f_104204_ = tailSwingAlternative;
            this.tailEnd.f_104204_ = tailSwingAlternative;
        }
    }
}

