/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import de.markusbordihn.playercompanions.client.model.PlayerCompanionModel;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RoosterModel<T extends TamableAnimal>
extends AgeableListModel<T>
implements PlayerCompanionModel {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart leftWing;
    private final ModelPart rightHand;
    private final ModelPart rightLeg;
    private final ModelPart rightWing;
    private final ModelPart tail;

    public RoosterModel(ModelPart modelPart) {
        this.body = modelPart.m_171324_("body");
        this.head = modelPart.m_171324_("head");
        this.leftLeg = modelPart.m_171324_("left_leg");
        this.leftWing = modelPart.m_171324_("left_wing");
        this.rightHand = modelPart.m_171324_("right_hand");
        this.rightLeg = modelPart.m_171324_("right_leg");
        this.rightWing = modelPart.m_171324_("right_wing");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -3.0f, -6.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(10, 14).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 7).m_171488_(-2.0f, 4.0f, 0.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 27).m_171488_(-3.0f, -2.0f, -5.0f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(18, 24).m_171488_(-3.0f, -3.0f, -4.0f, 6.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(18, 0).m_171488_(-1.0f, -4.5f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(11, 29).m_171488_(-1.0f, -1.5f, -1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.5f, (float)6.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        tail.m_171599_("tail_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -0.75f, 1.075f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-15.0f, (float)8.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        tail.m_171599_("tail_r3", CubeListBuilder.m_171558_().m_171514_(10, 18).m_171488_(-1.0f, -1.0f, -1.05f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-15.1924f, (float)6.5328f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-2.002f, -6.0f, -2.002f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)-4.0f));
        head.m_171599_("feather_r1", CubeListBuilder.m_171558_().m_171514_(30, 14).m_171488_(-0.5f, -1.5f, 0.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(21, 30).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.5f, (float)-0.5f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        head.m_171599_("comb", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-1.0f, -4.0f, -4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(29, 27).m_171488_(-1.0f, 2.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)1.0f));
        partDefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(29, 27).m_171488_(-1.0f, 2.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)19.0f, (float)1.0f));
        PartDefinition rightWing = partDefinition.m_171599_("right_wing", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)0.0f));
        rightWing.m_171599_("wing0_r1", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-0.5f, -2.5f, -4.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)2.5f, (float)1.0f, (float)3.1416f, (float)3.1416f, (float)0.0f));
        partDefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(0.0f, 0.0f, -3.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)13.0f, (float)0.0f));
        partDefinition.m_171599_("right_hand", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.2f, (float)0.4f, (float)0.3f, (float)-120.0f, (float)180.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.rightLeg, this.leftLeg, this.rightWing, this.leftWing);
    }

    @Override
    public ModelPart rightHand() {
        return this.rightHand;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.body.m_104227_(0.0f, 20.0f, 0.0f);
            this.head.m_104227_(0.0f, 18.0f, -4.0f);
            this.leftWing.m_104227_(3.0f, 17.0f, 0.0f);
            this.rightWing.m_104227_(-3.0f, 17.0f, 0.0f);
            this.tail.m_104227_(0.0f, 5.0f, -4.0f);
            this.tail.f_104203_ = -0.45f;
            this.rightLeg.f_104207_ = false;
            this.leftLeg.f_104207_ = false;
        } else {
            this.body.m_104227_(0.0f, 16.0f, 0.0f);
            this.head.m_104227_(0.0f, 14.0f, -4.0f);
            this.leftWing.m_104227_(3.0f, 13.0f, 0.0f);
            this.rightWing.m_104227_(-3.0f, 13.0f, 0.0f);
            this.tail.m_104227_(0.0f, 8.0f, 0.0f);
            this.tail.f_104203_ = 0.0f;
            this.rightLeg.f_104207_ = true;
            this.leftLeg.f_104207_ = true;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightWing.f_104205_ = ageInTicks;
            this.leftWing.f_104205_ = -ageInTicks;
        }
    }
}

