/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import java.util.Random;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmallGhastModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart[] tentacles = new ModelPart[9];

    public SmallGhastModel(ModelPart modelPart) {
        this.body = modelPart.m_171324_("body");
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = modelPart.m_171324_("tentacle" + i);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -30.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)17.6f, (float)0.0f));
        Random random = new Random(1660L);
        for (int i = 0; i < 9; ++i) {
            float f = (((float)(i % 3) - (float)i / 3.0f % 2.0f * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
            float f1 = ((float)i / 3.0f / 2.0f * 2.0f - 1.3f) * 5.0f;
            int j = random.nextInt(7) + 8;
            partDefinition.m_171599_("tentacle" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, (float)j, 2.0f), PartPose.m_171419_((float)f, (float)2.6f, (float)f1));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            for (int i = 0; i < this.tentacles.length; ++i) {
                this.tentacles[i].f_104203_ = 0.2f * Mth.m_14031_((float)(ageInTicks * 0.3f + (float)i)) + 0.4f;
            }
        }
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.body.m_104227_(0.0f, 34.0f, 0.0f);
            for (int i = 0; i < this.tentacles.length; ++i) {
                float f = (((float)(i % 3) - (float)i / 3.0f % 2.0f * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
                float f1 = ((float)i / 3.0f / 2.0f * 2.0f - 1.3f) * 5.0f;
                this.tentacles[i].m_104227_(f, 20.6f, f1 - 0.5f);
                this.tentacles[i].f_104203_ = 1.4f;
            }
        } else {
            this.body.m_104227_(0.0f, 20.0f, 0.0f);
            for (int i = 0; i < this.tentacles.length; ++i) {
                float f = (((float)(i % 3) - (float)i / 3.0f % 2.0f * 0.5f + 0.25f) / 2.0f * 2.0f - 1.0f) * 5.0f;
                float f1 = ((float)i / 3.0f / 2.0f * 2.0f - 1.3f) * 5.0f;
                this.tentacles[i].m_104227_(f, 2.6f, f1);
            }
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.tentacles[0], this.tentacles[1], this.tentacles[2], this.tentacles[3], this.tentacles[4], this.tentacles[5], this.tentacles[6], this.tentacles[7], this.tentacles[8]);
    }
}

