/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SmallSlimeModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    private static final PartPose partPoseOffset = PartPose.m_171419_((float)0.1f, (float)19.9f, (float)-1.6f);
    private final ModelPart body;
    private final ModelPart mouth;
    private final ModelPart rightEye;
    private final ModelPart leftEye;

    public SmallSlimeModel(ModelPart modelPart) {
        this.body = modelPart.m_171324_("body");
        this.leftEye = modelPart.m_171324_("left_eye");
        this.mouth = modelPart.m_171324_("mouth");
        this.rightEye = modelPart.m_171324_("right_eye");
    }

    public static LayerDefinition createOuterBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.1f, -3.9f, -2.4f, 8.0f, 8.0f, 8.0f), partPoseOffset);
        partDefinition.m_171599_("mouth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("right_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("left_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public static LayerDefinition createInnerBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.1f, -2.9f, -1.4f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), partPoseOffset);
        partDefinition.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171481_(1.25f, -1.9f, -1.9f, 2.0f, 2.0f, 2.0f), partPoseOffset);
        partDefinition.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-3.25f, -1.9f, -1.9f, 2.0f, 2.0f, 2.0f), partPoseOffset);
        partDefinition.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171481_(0.0f, 1.0f, -1.9f, 1.0f, 1.0f, 1.0f), partPoseOffset);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.mouth, this.leftEye, this.rightEye);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (this.f_102610_) {
            this.leftEye.m_104227_(1.0f, 16.8f, -2.2f);
            this.mouth.m_104227_(0.1f, 16.5f, -2.2f);
            this.rightEye.m_104227_(-1.0f, 16.8f, -2.2f);
        } else {
            this.leftEye.m_104227_(0.1f, 19.9f, -1.6f);
            this.mouth.m_104227_(0.1f, 19.9f, -1.6f);
            this.rightEye.m_104227_(0.1f, 19.9f, -1.6f);
        }
    }
}

