/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnailModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftEye;
    private final ModelPart rightEye;
    private final ModelPart house;

    public SnailModel(ModelPart modelPart) {
        this.root = modelPart;
        this.body = this.root.m_171324_("body");
        this.leftEye = this.root.m_171324_("eyes").m_171324_("left_eye");
        this.rightEye = this.root.m_171324_("eyes").m_171324_("right_eye");
        this.house = this.root.m_171324_("house");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 15).m_171488_(-2.0f, -4.0f, -6.0f, 4.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171488_(-3.0f, -1.0f, -7.0f, 6.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition eyes = partDefinition.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.75f, (float)-4.5f));
        eyes.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.75f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-2.0f, -0.75f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        eyes.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.5f, -2.75f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(1.0f, -0.75f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition house = partDefinition.m_171599_("house", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)3.0f));
        house.m_171599_("house_r1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-3.0f, -4.5f, -4.25f, 6.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.leftEye, this.rightEye);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.house);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public ModelPart root() {
        return this.root;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.body.m_104227_(0.0f, 25.1f, 0.5f);
            this.leftEye.m_104227_(-0.001f, 17.75f, -4.5f);
            this.rightEye.m_104227_(0.001f, 17.75f, -4.5f);
            this.house.f_104203_ = 0.0927f;
        } else {
            this.body.m_104227_(0.0f, 24.0f, 0.0f);
            if (this.f_102610_) {
                this.leftEye.m_104227_(0.0f, 14.25f, -4.5f);
                this.rightEye.m_104227_(0.0f, 14.25f, -4.5f);
            } else {
                this.leftEye.m_104227_(0.0f, 15.75f, -4.5f);
                this.rightEye.m_104227_(0.0f, 15.75f, -4.5f);
            }
            this.house.f_104203_ = -0.3927f;
        }
    }
}

