/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.model;

import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WelshCorgiModel<T extends TamableAnimal>
extends AgeableListModel<T> {
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart tail;
    private final ModelPart tongue;

    public WelshCorgiModel(ModelPart modelPart) {
        super(true, 8.0f, 3.35f);
        this.head = modelPart.m_171324_("head");
        this.body = modelPart.m_171324_("body");
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.tail = this.body.m_171324_("tail");
        this.tongue = this.head.m_171324_("snout").m_171324_("tongue");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-3.0f, -3.0f, -5.0f, 6.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(17, 21).m_171488_(-3.0f, -4.5f, -3.0f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(21, 7).m_171488_(-3.5f, -4.0f, -4.0f, 7.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-3.5f, -2.825f, -1.25f, 7.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)4.5f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)7.5f));
        tail.m_171599_("tail_r1", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-1.0f, -2.75f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.0f, -5.0f, 8.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)-1.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        rightEar.m_171599_("right_ear_r1", CubeListBuilder.m_171558_().m_171514_(22, 17).m_171488_(-1.5f, -5.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 31).m_171488_(-2.0f, -4.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-2.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        leftEar.m_171599_("left_ear_r1", CubeListBuilder.m_171558_().m_171514_(22, 17).m_171488_(-0.5f, -5.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 31).m_171488_(-1.0f, -4.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)-2.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition snout = head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.0f, 1.9998f, -8.275f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-0.5f, 1.825f, -8.45f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        snout.m_171599_("snout_r1", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-1.0f, -0.625f, 1.1f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-8.25f, (float)0.3927f, (float)0.0f, (float)0.0f));
        snout.m_171599_("snout_r2", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-0.975f, -1.0001f, 0.125f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-8.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        snout.m_171599_("snout_r3", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-1.025f, -1.0f, 0.125f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-8.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        snout.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(0, 2).m_171488_(-0.5f, 3.25f, -8.3f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(-3.005f, -4.0f, 5.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-1.0f));
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(1.005f, -4.0f, 5.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-1.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(-3.005f, -4.0f, -3.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-1.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(1.005f, -4.0f, -3.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.leftFrontLeg, this.leftHindLeg, this.rightFrontLeg, this.rightHindLeg);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        if (entity.m_21825_()) {
            this.body.f_104203_ = -0.62831855f;
            this.tail.f_104203_ = 0.7853982f;
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 13.0f, -4.5f);
            } else {
                this.head.m_104227_(0.0f, 10.0f, -1.5f);
            }
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
            this.rightHindLeg.f_104203_ = 80.0f;
            this.rightHindLeg.m_104227_(0.0f, 16.5f, 0.5f);
            this.leftHindLeg.f_104203_ = 80.0f;
            this.leftHindLeg.m_104227_(0.0f, 16.5f, 0.5f);
            this.rightFrontLeg.f_104203_ = -0.2617994f;
            this.rightFrontLeg.m_104227_(0.0f, 24.0f, -2.0f);
            this.leftFrontLeg.f_104203_ = -0.2617994f;
            this.leftFrontLeg.m_104227_(0.0f, 24.0f, -2.0f);
            this.tongue.f_104207_ = true;
        } else {
            this.body.m_104227_(0.0f, 16.0f, 0.0f);
            this.body.f_104205_ = 0.0f;
            this.body.f_104203_ = 0.0f;
            this.rightHindLeg.m_104227_(0.0f, 24.0f, -1.0f);
            this.leftHindLeg.m_104227_(0.0f, 24.0f, -1.0f);
            this.rightFrontLeg.m_104227_(0.0f, 24.0f, -1.0f);
            this.leftFrontLeg.m_104227_(0.0f, 24.0f, -1.0f);
            this.head.m_104227_(0.0f, 11.0f, -1.0f);
            if (this.f_102610_) {
                this.head.m_104227_(0.0f, 14.0f, -4.0f);
            } else {
                this.head.m_104227_(0.0f, 11.0f, -1.0f);
            }
            this.tail.m_104227_(0.0f, 1.5f, 7.5f);
            this.tail.f_104203_ = 0.0f;
            this.rightHindLeg.f_104207_ = true;
            this.leftHindLeg.f_104207_ = true;
            this.rightFrontLeg.f_104207_ = true;
            this.leftFrontLeg.f_104207_ = true;
            this.tongue.f_104207_ = false;
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_21224_()) {
            return;
        }
        if (!entity.m_21825_()) {
            this.head.f_104203_ = headPitch * 0.014279967f;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.9f;
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 0.3f * limbSwingAmount;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 0.3f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f)) * 0.3f * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 1.6662f + (float)Math.PI)) * 0.3f * limbSwingAmount;
        }
    }
}

