/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.playercompanions.client.model.DobutsuModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.client.renderer.layers.HandItemLayer;
import de.markusbordihn.playercompanions.client.textures.PlayerTextureManager;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Dobutsu;
import de.markusbordihn.playercompanions.skin.SkinType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DobutsuRenderer
extends MobRenderer<Dobutsu, DobutsuModel<Dobutsu>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/dobutsu/dobutsu_default.png"));
        hashMap.put(PlayerCompanionVariant.CREEPER, new ResourceLocation("player_companions", "textures/entity/dobutsu/dobutsu_creeper.png"));
        hashMap.put(PlayerCompanionVariant.ENDERMAN, new ResourceLocation("player_companions", "textures/entity/dobutsu/dobutsu_enderman.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public DobutsuRenderer(EntityRendererProvider.Context context) {
        super(context, new DobutsuModel(context.m_174023_(ClientRenderer.DOBUTSU)), 0.3f);
        this.m_115326_(new HandItemLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Dobutsu entity) {
        return switch (entity.getSkinType()) {
            case SkinType.PLAYER_SKIN, SkinType.SECURE_REMOTE_URL, SkinType.INSECURE_REMOTE_URL -> PlayerTextureManager.getOrCreateTextureWithDefault(entity, DEFAULT_TEXTURE);
            default -> TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
        };
    }

    protected void scale(Dobutsu entity, PoseStack poseStack, float unused) {
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
    }
}

