/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.playercompanions.client.model.FairyModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Fairy;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FairyRenderer
extends HumanoidMobRenderer<Fairy, FairyModel<Fairy>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/fairy/fairy_default.png"));
        hashMap.put(PlayerCompanionVariant.BLUE, new ResourceLocation("player_companions", "textures/entity/fairy/fairy_blue.png"));
        hashMap.put(PlayerCompanionVariant.RED, new ResourceLocation("player_companions", "textures/entity/fairy/fairy_red.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public FairyRenderer(EntityRendererProvider.Context context) {
        super(context, new FairyModel(context.m_174023_(ClientRenderer.FAIRY)), 0.3f);
    }

    public ResourceLocation getTextureLocation(Fairy entity) {
        return TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
    }

    protected int getBlockLightLevel(Fairy entity, BlockPos blockPos) {
        return 15;
    }

    protected void scale(Fairy entity, PoseStack poseStack, float unused) {
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
    }
}

