/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import de.markusbordihn.playercompanions.client.model.LizardModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Lizard;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LizardRenderer
extends MobRenderer<Lizard, LizardModel<Lizard>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/lizard/lizard_default.png"));
        hashMap.put(PlayerCompanionVariant.DESERT, new ResourceLocation("player_companions", "textures/entity/lizard/lizard_desert.png"));
        hashMap.put(PlayerCompanionVariant.GREEN, new ResourceLocation("player_companions", "textures/entity/lizard/lizard_green.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public LizardRenderer(EntityRendererProvider.Context context) {
        super(context, new LizardModel(context.m_174023_(ClientRenderer.LIZARD)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Lizard entity) {
        return TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
    }
}

