/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import de.markusbordihn.playercompanions.client.model.PigModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Pig;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigRenderer
extends MobRenderer<Pig, PigModel<Pig>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/pig/pig_default.png"));
        hashMap.put(PlayerCompanionVariant.SPOTTED, new ResourceLocation("player_companions", "textures/entity/pig/pig_spotted.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public PigRenderer(EntityRendererProvider.Context context) {
        super(context, new PigModel(context.m_174023_(ClientRenderer.PIG)), 0.7f);
    }

    public ResourceLocation getTextureLocation(Pig entity) {
        return TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
    }
}

