/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import de.markusbordihn.playercompanions.client.model.RoosterModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.client.renderer.layers.HandItemLayer;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Rooster;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RoosterRenderer
extends MobRenderer<Rooster, RoosterModel<Rooster>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/rooster/rooster_default.png"));
        hashMap.put(PlayerCompanionVariant.MIXED, new ResourceLocation("player_companions", "textures/entity/rooster/rooster_mixed.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public RoosterRenderer(EntityRendererProvider.Context context) {
        super(context, new RoosterModel(context.m_174023_(ClientRenderer.ROOSTER)), 0.35f);
        this.m_115326_(new HandItemLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Rooster entity) {
        return TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
    }

    protected float getBob(Rooster entity, float delay) {
        float f = Mth.m_14179_((float)delay, (float)entity.getOFlap(), (float)entity.getFlap());
        float f1 = Mth.m_14179_((float)delay, (float)entity.getOFlapSpeed(), (float)entity.getFlapSpeed());
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }
}

