/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.companions;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.playercompanions.client.model.SamuraiModel;
import de.markusbordihn.playercompanions.client.renderer.ClientRenderer;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.companions.Samurai;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SamuraiRenderer
extends HumanoidMobRenderer<Samurai, SamuraiModel<Samurai>> {
    protected static final Map<PlayerCompanionVariant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, new ResourceLocation("player_companions", "textures/entity/samurai/samurai_default.png"));
        hashMap.put(PlayerCompanionVariant.BLUE, new ResourceLocation("player_companions", "textures/entity/samurai/samurai_blue.png"));
        hashMap.put(PlayerCompanionVariant.BLACK, new ResourceLocation("player_companions", "textures/entity/samurai/samurai_black.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)PlayerCompanionVariant.DEFAULT);

    public SamuraiRenderer(EntityRendererProvider.Context context) {
        super(context, new SamuraiModel(context.m_174023_(ClientRenderer.SAMURAI)), 0.3f);
    }

    public ResourceLocation getTextureLocation(Samurai entity) {
        return TEXTURE_BY_VARIANT.getOrDefault((Object)entity.getVariant(), DEFAULT_TEXTURE);
    }

    protected int getBlockLightLevel(Samurai entity, BlockPos blockPos) {
        return 15;
    }

    protected void scale(Samurai entity, PoseStack poseStack, float unused) {
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
    }
}

