/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.playercompanions.client.model.PlayerCompanionModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandItemLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private final ItemInHandRenderer itemInHandRenderer;
    ModelPart rightHand;
    ModelPart leftHand;

    public HandItemLayer(RenderLayerParent<T, M> parent, ItemInHandRenderer itemInHandRenderer) {
        super(parent);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int lightLevel, T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float ageInTicks2, float netHeadYaw, float headPitch) {
        ItemStack itemStackMainHand = entity.m_21205_();
        EntityModel entityModel = this.m_117386_();
        if (entityModel instanceof PlayerCompanionModel) {
            PlayerCompanionModel playerCompanionModel = (PlayerCompanionModel)entityModel;
            this.leftHand = playerCompanionModel.leftHand();
            this.rightHand = playerCompanionModel.rightHand();
        }
        if (this.rightHand != null) {
            this.renderRightHandItem((LivingEntity)entity, itemStackMainHand, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, buffer, lightLevel);
        }
    }

    protected void renderRightHandItem(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource buffer, int lightLevel) {
        if (!itemStack.m_41619_()) {
            poseStack.m_85836_();
            if (this.rightHand != null) {
                poseStack.m_252880_(this.rightHand.f_104200_, this.rightHand.f_104201_, this.rightHand.f_104202_);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(this.rightHand.f_104203_));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rightHand.f_104204_));
            } else {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            }
            boolean flag = humanoidArm == HumanoidArm.LEFT;
            poseStack.m_85837_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            this.itemInHandRenderer.m_269530_(livingEntity, itemStack, transformType, flag, poseStack, buffer, lightLevel);
            poseStack.m_85849_();
        }
    }
}

