/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.screen;

import de.markusbordihn.playercompanions.client.screen.CompanionScreenHelper;
import de.markusbordihn.playercompanions.container.CompanionMenu;
import de.markusbordihn.playercompanions.data.Experience;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import de.markusbordihn.playercompanions.entity.ActionType;
import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.PlayerCompanionCommand;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.network.NetworkHandler;
import de.markusbordihn.playercompanions.skin.SkinType;
import de.markusbordihn.playercompanions.utils.PlayersUtils;
import java.time.Instant;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CompanionScreen<T extends CompanionMenu>
extends AbstractContainerScreen<T> {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final float STATES_SCALE = 0.8f;
    private static final int ADD_SKIN_DELAY = 20;
    private static final ResourceLocation DIALOG_TEXTURE = new ResourceLocation("player_companions", "textures/container/dialog.png");
    private static final ResourceLocation SYMBOLS_TEXTURE = new ResourceLocation("player_companions", "textures/container/symbols.png");
    protected static int nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond();
    protected final Entity entity;
    protected final PlayerCompanionEntity playerCompanionEntity;
    private ResourceLocation backgroundTexture = new ResourceLocation("player_companions", "textures/container/player_companion.png");
    private Button clearTextureSettingsButton = null;
    private Button closeTextureSettingsButton = null;
    private Button saveTextureSettingsButton = null;
    private Button actionTypeFollowButton = null;
    private Button actionTypeSitButton = null;
    private Button aggressionLevelDefaultButton = null;
    private ImageButton aggressiveLevelPreviousButton = null;
    private ImageButton aggressiveLevelNextButton = null;
    private EditBox textureSkinLocationBox;
    private String formerTextureSkinLocation = "";
    private boolean showTextureSettings = false;
    private boolean canTextureSkinLocationChange = true;
    private float xMouse;
    private float yMouse;
    private int leftPosDialog = this.f_97735_ - 18;
    private int topPosDialog = this.f_97736_ + 90;

    public CompanionScreen(T menu, Inventory inventory, Component component, ResourceLocation backgroundTexture) {
        this(menu, inventory, component);
        this.backgroundTexture = backgroundTexture;
    }

    public CompanionScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        PlayerCompanionEntity playerCompanionEntityCast;
        Entity entity = this.entity = ((CompanionMenu)((Object)menu)).getPlayerCompanionEntity();
        this.playerCompanionEntity = entity instanceof PlayerCompanionEntity ? (playerCompanionEntityCast = (PlayerCompanionEntity)entity) : null;
    }

    private static void updateNextTextureSkinLocationChange() {
        nextTextureSkinLocationChange = (int)Instant.now().getEpochSecond() + 20;
    }

    private void renderEntityActions(PlayerCompanionData playerCompanionData, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"Infos and Control"), x + 25, y, 0xFFFFFF);
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("Action: " + playerCompanionData.getEntityActionType())), x, y += 15, 0x404040, false);
        y += 15;
        if (this.playerCompanionEntity != null) {
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("Type: " + this.playerCompanionEntity.getCompanionType())), x, y, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)("Variant: " + this.playerCompanionEntity.getVariant())), x, y += 15, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"text.player_companions.tamed_companion_level", (Object[])new Object[]{this.playerCompanionEntity.getExperienceLevel(), this.playerCompanionEntity.getExperience(), Experience.getExperienceForNextLevel(this.playerCompanionEntity.getExperienceLevel())}), x, y += 15, 0x404040, false);
            y += 15;
        }
        guiGraphics.m_280168_().m_85849_();
        this.actionTypeFollowButton.m_252865_(x);
        this.actionTypeFollowButton.m_253211_(y);
        this.actionTypeFollowButton.f_93624_ = true;
        this.actionTypeFollowButton.f_93623_ = !ActionType.FOLLOW.equals((Object)playerCompanionData.getEntityActionType());
        this.actionTypeSitButton.m_252865_(x);
        this.actionTypeSitButton.m_253211_(y += 25);
        this.actionTypeSitButton.f_93624_ = true;
        this.actionTypeSitButton.f_93623_ = !ActionType.SIT.equals((Object)playerCompanionData.getEntityActionType());
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Aggression Level"), x, y += 30, 0x404040, false);
        guiGraphics.m_280168_().m_85849_();
        y += 12;
        AggressionLevel aggressionLevel = playerCompanionData.getEntityAggressionLevel();
        if (this.playerCompanionEntity != null && aggressionLevel != this.playerCompanionEntity.getFirstAggressionLevel()) {
            this.aggressiveLevelPreviousButton.m_252865_(x);
            this.aggressiveLevelPreviousButton.m_253211_(y - 1);
            this.aggressiveLevelPreviousButton.f_93624_ = true;
        } else {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280218_(SYMBOLS_TEXTURE, x, y - 1, 18, 19, 7, 9);
            this.aggressiveLevelNextButton.f_93624_ = false;
            guiGraphics.m_280168_().m_85849_();
            this.aggressiveLevelPreviousButton.f_93624_ = false;
        }
        if (this.playerCompanionEntity != null && aggressionLevel != this.playerCompanionEntity.getLastAggressionLevel()) {
            this.aggressiveLevelNextButton.m_252865_(x + 125);
            this.aggressiveLevelNextButton.m_253211_(y - 1);
            this.aggressiveLevelNextButton.f_93624_ = true;
        } else {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280218_(SYMBOLS_TEXTURE, x + 125, y - 1, 25, 19, 7, 9);
            this.aggressiveLevelNextButton.f_93624_ = false;
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280509_(x, y - 2, x + 132, y - 1, -16777216);
        guiGraphics.m_280509_(x + 7, y - 1, x + 125, y + 8, -9474193);
        guiGraphics.m_280509_(x, y + 8, x + 132, y + 9, -13421773);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)("text.player_companions.aggression_level." + aggressionLevel.name())), x + 9, y, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
        this.aggressionLevelDefaultButton.m_252865_(x);
        this.aggressionLevelDefaultButton.m_253211_(y += 10);
        this.aggressionLevelDefaultButton.f_93624_ = true;
    }

    private void renderEntityStats(PlayerCompanionEntity playerCompanionEntity, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280509_(x + 24, y + 17, x + 50, y + 105, 0x4F000000);
        int leftPos = x + 23;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280218_(SYMBOLS_TEXTURE, leftPos, y + 19, 1, 1, 16, 16);
        guiGraphics.m_280218_(SYMBOLS_TEXTURE, leftPos, y + 36, 1, 18, 16, 16);
        guiGraphics.m_280218_(SYMBOLS_TEXTURE, leftPos, y + 53, 1, 35, 16, 16);
        guiGraphics.m_280218_(SYMBOLS_TEXTURE, leftPos, y + 90, 1, 69, 16, 16);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 0.8f);
        leftPos = (int)((float)(x + 38) / 0.8f);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)((int)playerCompanionEntity.m_21223_() + " / " + (int)playerCompanionEntity.m_21233_())), leftPos, (int)((float)(y + 23) / 0.8f), 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("" + playerCompanionEntity.m_21230_())), leftPos, (int)((float)(y + 41) / 0.8f), 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("" + playerCompanionEntity.getAttackDamage())), leftPos, (int)((float)(y + 58) / 0.8f), 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("" + playerCompanionEntity.getExperienceLevel())), leftPos, (int)((float)(y + 95) / 0.8f), 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderTextureSettings(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 900.0f);
        this.renderDialogBg(guiGraphics, this.leftPosDialog, this.topPosDialog, (Component)Component.m_237113_((String)"Change Player Companion Skin"));
        guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Use a Player Name / Skin URL"), this.leftPosDialog + 10, this.topPosDialog + 25, 0x404040, false);
        this.textureSkinLocationBox.m_88315_(guiGraphics, x, y, partialTicks);
        this.clearTextureSettingsButton.m_88315_(guiGraphics, x, y, partialTicks);
        this.saveTextureSettingsButton.m_88315_(guiGraphics, x, y, partialTicks);
        this.closeTextureSettingsButton.m_88315_(guiGraphics, x, y, partialTicks);
        if (!this.canTextureSkinLocationChange) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280218_(DIALOG_TEXTURE, this.leftPosDialog + 78, this.topPosDialog + 73, 236, 17, 7, 10);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderDialogBg(GuiGraphics guiGraphics, int x, int y, Component title) {
        guiGraphics.m_280218_(DIALOG_TEXTURE, x, y, 0, 0, 230, 95);
        guiGraphics.m_280614_(this.f_96547_, title, x + 10, y + 10, 0x404040, false);
    }

    protected void showTextureSettings(boolean visible) {
        this.showTextureSettings = visible;
        this.clearTextureSettingsButton.f_93624_ = visible;
        this.saveTextureSettingsButton.f_93624_ = visible;
        this.closeTextureSettingsButton.f_93624_ = visible;
        this.textureSkinLocationBox.f_93624_ = visible;
        if (visible && this.playerCompanionEntity != null) {
            this.textureSkinLocationBox.m_94144_(this.formerTextureSkinLocation);
        }
    }

    private void clearTextureSkinLocation() {
        if (!this.textureSkinLocationBox.m_94155_().isEmpty()) {
            this.textureSkinLocationBox.m_94144_("");
        }
    }

    private void saveTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        if (textureSkinLocationValue != null && !textureSkinLocationValue.equals(this.formerTextureSkinLocation) && (textureSkinLocationValue.isEmpty() || PlayersUtils.isValidPlayerName(textureSkinLocationValue) || PlayersUtils.isValidUrl(textureSkinLocationValue))) {
            if (PlayersUtils.isValidPlayerName(textureSkinLocationValue)) {
                log.debug("Settings player user texture to {}", (Object)textureSkinLocationValue);
                NetworkHandler.skinChange(this.playerCompanionEntity.m_20148_(), textureSkinLocationValue, SkinType.PLAYER_SKIN);
            } else if (PlayersUtils.isValidUrl(textureSkinLocationValue)) {
                log.debug("Setting remote user texture to {}", (Object)textureSkinLocationValue);
                NetworkHandler.skinChange(this.playerCompanionEntity.m_20148_(), textureSkinLocationValue, SkinType.INSECURE_REMOTE_URL);
            }
            this.formerTextureSkinLocation = textureSkinLocationValue;
            CompanionScreen.updateNextTextureSkinLocationChange();
        }
    }

    private void validateTextureSkinLocation() {
        String textureSkinLocationValue = this.textureSkinLocationBox.m_94155_();
        boolean bl = this.canTextureSkinLocationChange = Instant.now().getEpochSecond() >= (long)nextTextureSkinLocationChange;
        this.saveTextureSettingsButton.f_93623_ = this.canTextureSkinLocationChange ? textureSkinLocationValue != null && !textureSkinLocationValue.equals(this.formerTextureSkinLocation) && (textureSkinLocationValue.isEmpty() || PlayersUtils.isValidPlayerName(textureSkinLocationValue) || PlayersUtils.isValidUrl(textureSkinLocationValue)) : textureSkinLocationValue.isEmpty();
        this.clearTextureSettingsButton.f_93623_ = textureSkinLocationValue != null && !textureSkinLocationValue.isEmpty();
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97726_ = 350;
        this.f_97727_ = 230;
        this.f_97728_ = 6;
        this.f_97729_ = 6;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97730_ = 6;
        this.f_97731_ = this.f_97727_ - 91;
        this.leftPosDialog = this.f_97735_ - 18;
        this.topPosDialog = this.f_97736_ + 85;
        this.textureSkinLocationBox = new EditBox(this.f_96547_, this.leftPosDialog + 10, this.topPosDialog + 42, 190, 20, (Component)Component.m_237115_((String)"text.player_companions.texture_url"));
        this.textureSkinLocationBox.m_94199_(256);
        this.textureSkinLocationBox.m_94144_(this.formerTextureSkinLocation);
        this.textureSkinLocationBox.m_94151_(consumer -> this.validateTextureSkinLocation());
        this.m_142416_((GuiEventListener)this.textureSkinLocationBox);
        this.textureSkinLocationBox.f_93624_ = false;
        this.clearTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"X"), onPress -> this.clearTextureSkinLocation()).m_252987_(this.leftPosDialog + 205, this.topPosDialog + 42, 20, 20).m_253136_());
        this.clearTextureSettingsButton.f_93624_ = false;
        this.saveTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.player_companions.save"), onPress -> {
            this.saveTextureSkinLocation();
            this.showTextureSettings(false);
        }).m_252987_(this.leftPosDialog + 10, this.topPosDialog + 68, 80, 20).m_253136_());
        this.saveTextureSettingsButton.f_93623_ = false;
        this.saveTextureSettingsButton.f_93624_ = false;
        this.closeTextureSettingsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.player_companions.cancel"), onPress -> this.showTextureSettings(false)).m_252987_(this.leftPosDialog + 145, this.topPosDialog + 68, 80, 20).m_253136_());
        this.closeTextureSettingsButton.f_93623_ = true;
        this.closeTextureSettingsButton.f_93624_ = false;
        this.actionTypeFollowButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.player_companions.follow"), onPress -> NetworkHandler.commandPlayerCompanion(this.playerCompanionEntity.m_20149_(), PlayerCompanionCommand.FOLLOW)).m_252987_(this.leftPosDialog + 10, this.topPosDialog + 68, 132, 20).m_253136_());
        this.actionTypeFollowButton.f_93624_ = false;
        this.actionTypeSitButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.player_companions.sit"), onPress -> NetworkHandler.commandPlayerCompanion(this.playerCompanionEntity.m_20149_(), PlayerCompanionCommand.SIT)).m_252987_(this.leftPosDialog + 10, this.topPosDialog + 68, 132, 20).m_253136_());
        this.actionTypeSitButton.f_93624_ = false;
        this.aggressiveLevelPreviousButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(1, 1, 7, 9, 18, 1, 9, SYMBOLS_TEXTURE, onPress -> NetworkHandler.commandPlayerCompanion(this.playerCompanionEntity.m_20149_(), PlayerCompanionCommand.AGGRESSION_LEVEL_PREVIOUS)));
        this.aggressiveLevelPreviousButton.f_93624_ = false;
        this.aggressiveLevelNextButton = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(1, 1, 7, 9, 25, 1, 9, SYMBOLS_TEXTURE, onPress -> NetworkHandler.commandPlayerCompanion(this.playerCompanionEntity.m_20149_(), PlayerCompanionCommand.AGGRESSION_LEVEL_NEXT)));
        this.aggressiveLevelNextButton.f_93624_ = false;
        this.aggressionLevelDefaultButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"text.player_companions.default_aggression"), onPress -> NetworkHandler.commandPlayerCompanion(this.playerCompanionEntity.m_20149_(), PlayerCompanionCommand.AGGRESSION_LEVEL_DEFAULT)).m_252987_(this.leftPosDialog + 10, this.topPosDialog + 68, 132, 20).m_253136_());
        this.aggressionLevelDefaultButton.f_93624_ = false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
        boolean renderTooltip = true;
        if (this.playerCompanionEntity != null) {
            PlayerCompanionData playerCompanionData = PlayerCompanionsClientData.getCompanion((LivingEntity)this.playerCompanionEntity);
            this.renderEntityStats(this.playerCompanionEntity, guiGraphics, this.f_97735_, this.f_97736_);
            this.renderEntityActions(playerCompanionData, guiGraphics, this.f_97735_ + 204, this.f_97736_ + 6);
            if (this.showTextureSettings) {
                this.renderTextureSettings(guiGraphics, x, y, partialTicks);
                renderTooltip = false;
            }
        }
        if (renderTooltip) {
            this.m_280072_(guiGraphics, x, y);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280163_(this.backgroundTexture, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 512, 256);
        if (this.playerCompanionEntity != null) {
            CompanionScreenHelper.renderEntity(this.f_97735_ + 59, this.f_97736_ + 70 + this.playerCompanionEntity.getEntityGuiTop(), (float)(this.f_97735_ + 58) - this.xMouse, (float)(this.f_97736_ + 40) - this.yMouse, this.playerCompanionEntity);
        }
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (!this.showTextureSettings || keyCode != 257 && keyCode != 335 && keyCode != 69) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        if (keyCode == 256) {
            this.showTextureSettings(false);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.saveTextureSkinLocation();
            this.showTextureSettings(false);
            return true;
        }
        return true;
    }
}

