/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.textures;

import com.mojang.blaze3d.platform.NativeImage;
import de.markusbordihn.playercompanions.utils.PlayersUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String TEXTURE_PREFIX = "player_companions_client_texture_";
    private static final HashMap<String, ResourceLocation> textureCache = new HashMap();
    private static Path textureCachePath = null;

    protected ModTextureManager() {
    }

    private static ResourceLocation addTexture(String name, File file) {
        if (ModTextureManager.hasTexture(name)) {
            log.warn("Texture with name {} already exists! Unable to add texture for file: {}", (Object)name, (Object)file);
            return ModTextureManager.getTexture(name);
        }
        Minecraft client = Minecraft.m_91087_();
        TextureManager textureManager = client.m_91097_();
        NativeImage nativeImage = ModTextureManager.getNativeImage(file);
        if (nativeImage == null) {
            log.error("Unable to create native image for file {}.", (Object)file);
            return null;
        }
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        String textureId = ModTextureManager.getId(name);
        ResourceLocation resourceLocation = textureManager.m_118490_(textureId, dynamicTexture);
        log.debug("Registered image {} as texture {} with {} to texture Manager.", (Object)nativeImage, (Object)dynamicTexture, (Object)resourceLocation);
        textureCache.put(textureId, resourceLocation);
        return resourceLocation;
    }

    public static ResourceLocation addTexture(String remoteUrl) {
        BufferedImage image;
        if (!PlayersUtils.isValidUrl(remoteUrl)) {
            log.error("Texture URL {} is invalid!", (Object)remoteUrl);
            return null;
        }
        if (ModTextureManager.hasTexture(remoteUrl)) {
            log.debug("Texture with {} already exists, will used cached version instead!", (Object)remoteUrl);
            return ModTextureManager.getTexture(remoteUrl);
        }
        String fileName = ModTextureManager.getFileName(remoteUrl);
        File file = new File(ModTextureManager.getTextureCacheDirectoryString(), fileName);
        if (file.exists()) {
            log.debug("Found downloaded file in cache, will re-used file {} for {}", (Object)file, (Object)remoteUrl);
            return ModTextureManager.addTexture(remoteUrl, file);
        }
        try {
            image = ImageIO.read(new URL(remoteUrl));
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("Unable to load texture from {} because of:", (Object)remoteUrl, (Object)exception);
            return null;
        }
        if (image == null) {
            log.error("Unable to get any valid texture from {}!", (Object)remoteUrl);
            return null;
        }
        if (image.getWidth() < 32 || image.getHeight() < 32 || image.getWidth() % 32 != 0 || image.getHeight() % 32 != 0) {
            log.error("Unable to get any valid texture from {}, got {}x{}!", (Object)remoteUrl, (Object)image.getWidth(), (Object)image.getHeight());
            return null;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("Unable to store texture from {} to {} because of:", (Object)remoteUrl, (Object)file, (Object)exception);
            return null;
        }
        return ModTextureManager.addTexture(remoteUrl, file);
    }

    public static String getId(String name) {
        return TEXTURE_PREFIX + name.hashCode();
    }

    public static String getFileName(String name) {
        return String.format("%s.png", ModTextureManager.getId(name)).replace("-", "0");
    }

    public static boolean hasTexture(String name) {
        return textureCache.containsKey(ModTextureManager.getId(name));
    }

    public static ResourceLocation getTexture(String name) {
        return textureCache.get(ModTextureManager.getId(name));
    }

    public static String getTextureCacheDirectoryString() {
        return ModTextureManager.getTextureCacheDirectory().toString();
    }

    public static Path getTextureCacheDirectory() {
        if (textureCachePath == null) {
            Path cacheDirectory = Paths.get(FMLPaths.GAMEDIR.get().resolve("player_companions").toString(), "texture_cache");
            if (!cacheDirectory.toFile().exists()) {
                log.info("Creating texture cache directory at {}", (Object)cacheDirectory);
                try {
                    Files.createDirectories(cacheDirectory, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    log.error("Unable to create texture cache directory at {} because of:", (Object)cacheDirectory, (Object)exception);
                }
            }
            textureCachePath = cacheDirectory;
        }
        return textureCachePath;
    }

    public static NativeImage getNativeImage(File file) {
        NativeImage nativeImage;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            log.error("Unable to get native image for file {} because of:", (Object)file, (Object)exception);
            return null;
        }
        if (nativeImage.m_84982_() == 64 && nativeImage.m_85084_() == 32) {
            log.info("Processing legacy image {} from 64x32 to 64x64 ...", (Object)nativeImage);
            nativeImage = ModTextureManager.getNativeImageFromLegacyImage(nativeImage);
        }
        return nativeImage;
    }

    public static NativeImage getNativeImageFromLegacyImage(NativeImage legacyNativeImage) {
        NativeImage nativeImage = new NativeImage(64, 64, true);
        nativeImage.m_85054_(legacyNativeImage);
        legacyNativeImage.close();
        nativeImage.m_84997_(0, 32, 64, 32, 0);
        nativeImage.m_85025_(4, 16, 16, 32, 4, 4, true, false);
        nativeImage.m_85025_(8, 16, 16, 32, 4, 4, true, false);
        nativeImage.m_85025_(0, 20, 24, 32, 4, 12, true, false);
        nativeImage.m_85025_(4, 20, 16, 32, 4, 12, true, false);
        nativeImage.m_85025_(8, 20, 8, 32, 4, 12, true, false);
        nativeImage.m_85025_(12, 20, 16, 32, 4, 12, true, false);
        nativeImage.m_85025_(44, 16, -8, 32, 4, 4, true, false);
        nativeImage.m_85025_(48, 16, -8, 32, 4, 4, true, false);
        nativeImage.m_85025_(40, 20, 0, 32, 4, 12, true, false);
        nativeImage.m_85025_(44, 20, -8, 32, 4, 12, true, false);
        nativeImage.m_85025_(48, 20, -16, 32, 4, 12, true, false);
        nativeImage.m_85025_(52, 20, -8, 32, 4, 12, true, false);
        return nativeImage;
    }
}

