/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.textures;

import com.mojang.blaze3d.platform.NativeImage;
import de.markusbordihn.playercompanions.client.textures.TextureModelKey;
import de.markusbordihn.playercompanions.skin.SkinModel;
import de.markusbordihn.playercompanions.utils.PlayersUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String TEXTURE_PREFIX = "player_companions_client_texture_";
    private static final String LOG_PREFIX = "[Texture Manager]";
    private static Path textureCachePath = null;

    protected TextureManager() {
    }

    private static ResourceLocation registerTexture(TextureModelKey textureModelKey, File file) {
        NativeImage nativeImage;
        Minecraft client = Minecraft.m_91087_();
        net.minecraft.client.renderer.texture.TextureManager textureManager = client.m_91097_();
        NativeImage nativeImage2 = nativeImage = textureModelKey.getSkinModel() == SkinModel.HUMANOID || textureModelKey.getSkinModel() == SkinModel.HUMANOID_SLIM ? TextureManager.getNativePlayerImage(file) : TextureManager.getNativeImage(file);
        if (nativeImage == null) {
            log.error("{} Unable to create native image for file {}.", (Object)LOG_PREFIX, (Object)file);
            return null;
        }
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        String resourceName = TextureManager.getResourceName(textureModelKey);
        ResourceLocation resourceLocation = textureManager.m_118490_(resourceName, dynamicTexture);
        log.debug("{} Registered image {} as texture {} with {}.", (Object)LOG_PREFIX, (Object)nativeImage, (Object)dynamicTexture, (Object)resourceLocation);
        return resourceLocation;
    }

    public static ResourceLocation addRemoteTexture(TextureModelKey textureModelKey, String remoteUrl, String targetDirectory) {
        BufferedImage image;
        if (!PlayersUtils.isValidUrl(remoteUrl)) {
            log.error("{} Texture URL {} is invalid!", (Object)LOG_PREFIX, (Object)remoteUrl);
            return null;
        }
        ResourceLocation cachedTexture = TextureManager.getCachedTexture(textureModelKey, targetDirectory);
        if (cachedTexture != null) {
            log.debug("{} Found downloaded file in cache, will re-used {} for {}", (Object)LOG_PREFIX, (Object)cachedTexture, (Object)remoteUrl);
            return cachedTexture;
        }
        try {
            URL remoteImageURL = new URL(remoteUrl);
            HttpURLConnection connection = (HttpURLConnection)remoteImageURL.openConnection();
            if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302) {
                String redirectUrl = connection.getHeaderField("Location");
                log.debug("{} Following redirect from {} to {}", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)redirectUrl);
                remoteUrl = redirectUrl;
            } else if (connection.getResponseCode() != 200) {
                log.error("{} Unable to load texture from URL {} because of: {}", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)connection.getResponseMessage());
                return null;
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("{} Unable to load texture from URL {} because of:", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)exception);
            return null;
        }
        try {
            image = ImageIO.read(new URL(remoteUrl));
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("{} Unable to load texture from {} because of:", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)exception);
            return null;
        }
        if (image == null) {
            log.error("{} Unable to get any valid texture from {}!", (Object)LOG_PREFIX, (Object)remoteUrl);
            return null;
        }
        if (image.getWidth() < 32 || image.getHeight() < 32 || image.getWidth() % 32 != 0 || image.getHeight() % 32 != 0) {
            log.error("{} Unable to get any valid texture from {}, got {}x{}!", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)image.getWidth(), (Object)image.getHeight());
            return null;
        }
        UUID uuid = textureModelKey.getUUID();
        File file = new File(targetDirectory, TextureManager.getFileName(uuid));
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException | IllegalArgumentException exception) {
            log.error("{} Unable to store texture from {} to {} because of:", (Object)LOG_PREFIX, (Object)remoteUrl, (Object)file, (Object)exception);
            return null;
        }
        return TextureManager.registerTexture(textureModelKey, file);
    }

    public static String getResourceName(TextureModelKey textureModelKey) {
        return TextureManager.getResourceName(textureModelKey.getUUID().toString(), textureModelKey.getSubType());
    }

    public static String getResourceName(String name, String type) {
        return (TEXTURE_PREFIX + type + "_" + name.replaceAll("[^a-z0-9_.-]", "")).toLowerCase();
    }

    public static String getFileName(UUID uuid) {
        return TextureManager.getFileName(uuid.toString());
    }

    public static String getFileName(String name) {
        return name.replaceAll("[^a-z0-9_.-]", "") + ".png";
    }

    public static ResourceLocation getCachedTexture(TextureModelKey textureModelKey, String targetDirectory) {
        String fileName = String.format("%s.png", textureModelKey.getUUID());
        File file = new File(targetDirectory, fileName);
        if (file.exists()) {
            log.debug("{} Found downloaded file in cache, will re-used file {} for {}", (Object)LOG_PREFIX, (Object)file, (Object)textureModelKey);
            return TextureManager.registerTexture(textureModelKey, file);
        }
        return null;
    }

    public static Path getTextureCacheDirectory() {
        if (textureCachePath == null) {
            Path cacheDirectory = Paths.get(FMLPaths.GAMEDIR.get().resolve("player_companions").toString(), "texture_cache");
            if (!cacheDirectory.toFile().exists()) {
                log.info("{} Creating texture cache directory at {}", (Object)LOG_PREFIX, (Object)cacheDirectory);
                try {
                    Files.createDirectories(cacheDirectory, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    log.error("{} Unable to create texture cache directory at {} because of:", (Object)LOG_PREFIX, (Object)cacheDirectory, (Object)exception);
                    return null;
                }
            }
            textureCachePath = cacheDirectory;
        }
        return textureCachePath;
    }

    public static NativeImage getNativeImage(File file) {
        return TextureManager.getNativeImage(file, false);
    }

    public static NativeImage getNativePlayerImage(File file) {
        return TextureManager.getNativeImage(file, true);
    }

    public static NativeImage getNativeImage(File file, boolean legacySupport) {
        NativeImage nativeImage;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            log.error("{} Unable to get native image for file {} because of:", (Object)LOG_PREFIX, (Object)file, (Object)exception);
            return null;
        }
        if (legacySupport && nativeImage.m_84982_() == 64 && nativeImage.m_85084_() == 32) {
            log.info("{} Processing legacy image {} from 64x32 to 64x64 ...", (Object)LOG_PREFIX, (Object)nativeImage);
            nativeImage = TextureManager.getNativeImageFromLegacyImage(nativeImage);
        }
        return nativeImage;
    }

    public static NativeImage getNativeImageFromLegacyImage(NativeImage legacyNativeImage) {
        NativeImage nativeImage = new NativeImage(64, 64, true);
        nativeImage.m_85054_(legacyNativeImage);
        legacyNativeImage.close();
        nativeImage.m_84997_(0, 32, 64, 32, 0);
        nativeImage.m_85025_(4, 16, 16, 32, 4, 4, true, false);
        nativeImage.m_85025_(8, 16, 16, 32, 4, 4, true, false);
        nativeImage.m_85025_(0, 20, 24, 32, 4, 12, true, false);
        nativeImage.m_85025_(4, 20, 16, 32, 4, 12, true, false);
        nativeImage.m_85025_(8, 20, 8, 32, 4, 12, true, false);
        nativeImage.m_85025_(12, 20, 16, 32, 4, 12, true, false);
        nativeImage.m_85025_(44, 16, -8, 32, 4, 4, true, false);
        nativeImage.m_85025_(48, 16, -8, 32, 4, 4, true, false);
        nativeImage.m_85025_(40, 20, 0, 32, 4, 12, true, false);
        nativeImage.m_85025_(44, 20, -8, 32, 4, 12, true, false);
        nativeImage.m_85025_(48, 20, -16, 32, 4, 12, true, false);
        nativeImage.m_85025_(52, 20, -8, 32, 4, 12, true, false);
        return nativeImage;
    }
}

