/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.client.textures;

import de.markusbordihn.playercompanions.skin.SkinModel;
import java.util.Objects;
import java.util.UUID;

public class TextureModelKey {
    private final UUID uuid;
    private final String subType;
    private SkinModel skinModel;

    public TextureModelKey(UUID uuid, SkinModel skinModel) {
        this.uuid = uuid;
        this.subType = skinModel != null ? skinModel.name() : "";
        this.skinModel = skinModel;
    }

    public TextureModelKey(UUID uuid, String subType) {
        this.uuid = uuid;
        this.subType = subType != null ? subType : "";
    }

    public TextureModelKey(String name, String subType) {
        this.uuid = UUID.nameUUIDFromBytes(name.getBytes());
        this.subType = subType != null ? subType : "";
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getSubType() {
        return this.subType;
    }

    public SkinModel getSkinModel() {
        return this.skinModel;
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.subType);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextureModelKey)) {
            return false;
        }
        TextureModelKey textureModelKey = (TextureModelKey)object;
        return this.uuid.equals(textureModelKey.uuid) && this.subType.equals(textureModelKey.subType);
    }
}

