/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.playercompanions.commands.CustomCommand;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerDataBackup;
import java.io.File;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class BackupCommand
extends CustomCommand {
    private static final BackupCommand command = new BackupCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"backup").requires(cs -> cs.m_6761_(2))).executes((Command)command)).then(Commands.m_82127_((String)"list").executes(command::runList))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"file_name", (ArgumentType)StringArgumentType.string()).executes(command::runLoad)))).then(Commands.m_82127_((String)"save").executes(command::runSave));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BackupCommand.sendFeedback(context, "The player companion backup commands allows to list, load or save the player companions data from/to the world/player_companions folder.\n===");
        return 0;
    }

    public int runList(CommandContext<CommandSourceStack> context) {
        List<File> backupFiles = PlayerCompanionsServerDataBackup.listBackup();
        if (backupFiles.isEmpty()) {
            BackupCommand.sendFeedback(context, "Unable to find any backups!");
        } else {
            BackupCommand.sendFeedback(context, String.format("Found %s backups files ...\n===", backupFiles.size()));
            for (File backupFile : backupFiles) {
                BackupCommand.sendFeedback(context, String.format("\u25cb %s", backupFile.getName().replace("-player_companions_data.nbt", "")));
            }
        }
        return 0;
    }

    public int runLoad(CommandContext<CommandSourceStack> context) {
        String fileName = StringArgumentType.getString(context, (String)"file_name") + "-player_companions_data.nbt";
        if (fileName.isEmpty() || fileName.contains("..") || fileName.contains("|") || fileName.contains("/") || fileName.contains("\\") || !fileName.endsWith("player_companions_data.nbt")) {
            BackupCommand.sendFeedback(context, String.format("Invalid file name %s !", fileName));
        } else {
            BackupCommand.sendFeedback(context, String.format("Try to load backups from %s...", fileName));
            if (PlayerCompanionsServerDataBackup.loadBackup(fileName)) {
                BackupCommand.sendFeedback(context, "Backup was successfully loaded.");
                BackupCommand.sendFeedback(context, "Please restart the server to make sure that the new data are used!");
            } else {
                BackupCommand.sendFeedback(context, "Failed to load backup, please check the logs for additional information!");
            }
        }
        return 0;
    }

    public int runSave(CommandContext<CommandSourceStack> context) {
        BackupCommand.sendFeedback(context, "Save backup ...");
        if (PlayerCompanionsServerDataBackup.saveBackup()) {
            BackupCommand.sendFeedback(context, "Backup was successfully created.");
        } else {
            BackupCommand.sendFeedback(context, "Failed to create backup, please check the logs for additional information!");
        }
        return 0;
    }
}

