/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.playercompanions.commands.CustomCommand;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class ListCommand
extends CustomCommand {
    private static final ListCommand command = new ListCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Map<UUID, PlayerCompanionData> playerCompanionsMap = PlayerCompanionsServerData.get().getCompanions();
        Iterator<PlayerCompanionData> playerCompanionIterator = playerCompanionsMap.values().iterator();
        ListCommand.sendFeedback(context, "All Player Companions (please check latest.log for full output)\n===");
        while (playerCompanionIterator.hasNext()) {
            PlayerCompanionData playerCompanion = playerCompanionIterator.next();
            if (playerCompanion == null) continue;
            ListCommand.sendFeedback(context, String.format("\u25cb %s : %s (%s)", new Object[]{playerCompanion.getOwnerName(), playerCompanion.getName(), playerCompanion.getType()}));
            log.info("{}", (Object)playerCompanion);
        }
        return 0;
    }
}

