/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.playercompanions.commands.CustomCommand;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class OverviewCommand
extends CustomCommand {
    private static final OverviewCommand command = new OverviewCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"overview").requires(cs -> cs.m_6761_(0))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Set<PlayerCompanionData> playerCompanionsSet = PlayerCompanionsServerData.get().getCompanions(player.m_20148_());
        if (playerCompanionsSet == null || playerCompanionsSet.isEmpty()) {
            OverviewCommand.sendFeedback(context, "Unable to find any owned companions!");
            return 0;
        }
        Iterator<PlayerCompanionData> playerCompanionIterator = playerCompanionsSet.iterator();
        OverviewCommand.sendFeedback(context, "Your owned Companions\n===");
        while (playerCompanionIterator.hasNext()) {
            PlayerCompanionData playerCompanion = playerCompanionIterator.next();
            if (playerCompanion == null) continue;
            OverviewCommand.sendFeedback(context, String.format("\u25cb %s (%s) [%s]", new Object[]{playerCompanion.getName(), playerCompanion.getType(), playerCompanion.getUUID()}));
        }
        return 0;
    }
}

