/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.playercompanions.commands.CustomCommand;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionSpawnManager;
import java.time.Instant;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class SummonCommand
extends CustomCommand {
    private static final SummonCommand command = new SummonCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").requires(cs -> cs.m_6761_(0))).executes((Command)command)).then(Commands.m_82129_((String)"UUID", (ArgumentType)StringArgumentType.string()).executes(command::runSummonCompanion));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Set<PlayerCompanionData> playerCompanionsSet = PlayerCompanionsServerData.get().getCompanions(player.m_20148_());
        if (playerCompanionsSet == null || playerCompanionsSet.isEmpty()) {
            SummonCommand.sendFeedback(context, "Unable to find any owned companions!");
            return 0;
        }
        Iterator<PlayerCompanionData> playerCompanionIterator = playerCompanionsSet.iterator();
        SummonCommand.sendFeedback(context, "Your owned Companions\n===");
        while (playerCompanionIterator.hasNext()) {
            PlayerCompanionData playerCompanion = playerCompanionIterator.next();
            if (playerCompanion == null) continue;
            MutableComponent summonCommand = Component.m_237115_((String)"text.player_companions.commands.summon.action").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/player_companions summon " + playerCompanion.getUUID())));
            SummonCommand.sendFeedback(context, (Component)Component.m_237110_((String)"text.player_companions.commands.summon.list_entry", (Object[])new Object[]{Component.m_237113_((String)playerCompanion.getName()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), playerCompanion.getType(), Component.m_237113_((String)("UUID:" + playerCompanion.getUUID())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), summonCommand}));
        }
        return 0;
    }

    public int runSummonCompanion(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID uuid;
        String companionUUID = StringArgumentType.getString(context, (String)"UUID");
        try {
            uuid = UUID.fromString(companionUUID);
        }
        catch (IllegalArgumentException exception) {
            SummonCommand.sendErrorFeedback(context, "Invalid player companions UUID " + companionUUID);
            return 0;
        }
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
        PlayerCompanionsServerData playerCompanionsServerData = PlayerCompanionsServerData.get();
        if (uuid == null || serverPlayer == null || playerCompanionsServerData == null) {
            SummonCommand.sendErrorFeedback(context, "Invalid arguments!");
            return 0;
        }
        PlayerCompanionData playerCompanionData = playerCompanionsServerData.getCompanion(uuid);
        if (playerCompanionData == null) {
            SummonCommand.sendErrorFeedback(context, "Unable to find player companion with UUID " + companionUUID);
            return 0;
        }
        if (!playerCompanionData.getOwnerUUID().equals(serverPlayer.m_20148_())) {
            SummonCommand.sendErrorFeedback(context, "Player " + serverPlayer.m_7755_().getString() + " is not owning player companion " + playerCompanionData.getName() + " with UUID " + companionUUID);
            return 0;
        }
        if (playerCompanionData.hasEntityRespawnTimer() && (long)playerCompanionData.getEntityRespawnTimer() > Instant.now().getEpochSecond()) {
            SummonCommand.sendErrorFeedback(context, "Unable summon player companion with UUID " + companionUUID + " because there is a active respawn timer for " + ((long)playerCompanionData.getEntityRespawnTimer() - Instant.now().getEpochSecond()) + " secs remaining!");
            return 0;
        }
        SummonCommand.sendFeedback(context, "Try to summon " + companionUUID + " for " + serverPlayer.m_7755_().getString() + " with " + playerCompanionData);
        PlayerCompanionSpawnManager.spawn(uuid, serverPlayer);
        return 0;
    }
}

