/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.container;

import de.markusbordihn.playercompanions.container.slots.ArmorSlot;
import de.markusbordihn.playercompanions.container.slots.DummySlot;
import de.markusbordihn.playercompanions.container.slots.HandSlot;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsClientData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompanionMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected static final int armorContainerSize = 4;
    protected static final int equipmentContainerSize = 8;
    protected static final int handContainerSize = 2;
    protected static final int inventoryContainerSize = 16;
    protected static final int slotSize = 18;
    protected final Container armorContainer;
    protected final Container equipmentContainer;
    protected final Container handContainer;
    protected final Container inventoryContainer;
    protected final Level level;
    protected final Player player;
    protected final PlayerCompanionData playerCompanionData;
    protected final UUID playerCompanionUUID;
    protected PlayerCompanionEntity playerCompanionEntity;
    private boolean dataLoaded = false;

    public CompanionMenu(MenuType<?> menuType, int windowId, Inventory inventory, UUID playerCompanionUUID) {
        this(menuType, windowId, inventory, (Container)new SimpleContainer(4), (Container)new SimpleContainer(8), (Container)new SimpleContainer(2), (Container)new SimpleContainer(16), playerCompanionUUID);
    }

    public CompanionMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(menuType, windowId, playerInventory, (Container)new SimpleContainer(4), (Container)new SimpleContainer(8), (Container)new SimpleContainer(2), (Container)new SimpleContainer(16), data.m_130259_());
    }

    public CompanionMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, Container armorContainer, Container equipmentContainer, Container handContainer, Container inventoryContainer, UUID playerCompanionUUID) {
        super(menuType, windowId);
        CompanionMenu.m_38869_((Container)armorContainer, (int)4);
        CompanionMenu.m_38869_((Container)equipmentContainer, (int)8);
        CompanionMenu.m_38869_((Container)handContainer, (int)2);
        CompanionMenu.m_38869_((Container)inventoryContainer, (int)16);
        this.dataLoaded = false;
        this.armorContainer = armorContainer;
        this.equipmentContainer = equipmentContainer;
        this.handContainer = handContainer;
        this.inventoryContainer = inventoryContainer;
        this.player = playerInventory.f_35978_;
        this.playerCompanionUUID = playerCompanionUUID;
        this.level = this.player.m_9236_();
        this.playerCompanionData = this.level.f_46443_ ? PlayerCompanionsClientData.getCompanion(this.playerCompanionUUID) : PlayerCompanionsServerData.get().getCompanion(this.playerCompanionUUID);
        if (this.playerCompanionData == null) {
            log.error("Unable to find Player Companion Data for {} on {}!", (Object)playerCompanionUUID, (Object)(this.level.f_46443_ ? "Client" : "Server"));
            return;
        }
        this.playerCompanionEntity = this.playerCompanionData.getPlayerCompanionEntity();
        if (!this.level.f_46443_) {
            this.loadArmor();
            this.loadHand();
            this.loadAdditionalContainer();
        }
        log.debug("CompanionsMenu client:{} companion:{} data:{} entity:{}", (Object)this.level.f_46443_, (Object)this.playerCompanionUUID, (Object)this.playerCompanionData, (Object)this.playerCompanionEntity);
        int playerCompanionEquipmentLeftStartPositionY = 17;
        int playerCompanionEquipmentLeftStartPositionX = 6;
        for (int armorSlot = 3; armorSlot >= 0; --armorSlot) {
            this.m_38897_(new ArmorSlot(this, this.armorContainer, 3 - armorSlot, playerCompanionEquipmentLeftStartPositionX, playerCompanionEquipmentLeftStartPositionY + armorSlot * 18));
        }
        int playerCompanionEquipmentRightStartPositionY = 17;
        int playerCompanionEquipmentRightStartPositionX = 96;
        for (int equipmentSlot = 0; equipmentSlot < 4; ++equipmentSlot) {
            this.m_38897_(new DummySlot(this.equipmentContainer, equipmentSlot + 4, playerCompanionEquipmentRightStartPositionX, playerCompanionEquipmentRightStartPositionY + equipmentSlot * 18));
        }
        int playerCompanionMainHandStartPositionY = 89;
        int playerCompanionMainHandStartPositionX = 6;
        this.m_38897_(new HandSlot(this, this.handContainer, EquipmentSlot.MAINHAND.m_20749_(), playerCompanionMainHandStartPositionX, playerCompanionMainHandStartPositionY));
        int playerCompanionOffHandStartPositionY = 89;
        int playerCompanionOffHandStartPositionX = 96;
        this.m_38897_(new HandSlot(this, this.handContainer, EquipmentSlot.OFFHAND.m_20749_(), playerCompanionOffHandStartPositionX, playerCompanionOffHandStartPositionY));
        this.addAdditionalSlots();
        int playerInventoryStartPositionY = 151;
        int playerInventoryStartPositionX = 6;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 209;
        int hotbarStartPositionX = 6;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
        if (!this.level.f_46443_) {
            this.dataLoaded = true;
        }
    }

    public void loadAdditionalContainer() {
    }

    public void addAdditionalSlots() {
    }

    public void loadArmor() {
        if (this.level.f_46443_ || this.playerCompanionData == null) {
            return;
        }
        NonNullList<ItemStack> armor = this.playerCompanionData.getArmorItems();
        for (int index = 0; index < armor.size(); ++index) {
            this.armorContainer.m_6836_(index, (ItemStack)armor.get(index));
        }
    }

    public void setArmorChanged(EquipmentSlot equipmentSlot, int slot, ItemStack itemStack) {
        if (this.level.f_46443_) {
            return;
        }
        if (this.playerCompanionEntity != null) {
            this.playerCompanionEntity.setArmorItem(equipmentSlot, itemStack);
        } else if (this.dataLoaded && this.playerCompanionData != null) {
            this.playerCompanionData.setArmorItem(slot, itemStack);
        }
    }

    public void loadHand() {
        if (this.level.f_46443_ || this.playerCompanionData == null) {
            return;
        }
        NonNullList<ItemStack> hand = this.playerCompanionData.getHandItems();
        for (int index = 0; index < hand.size(); ++index) {
            this.handContainer.m_6836_(index, (ItemStack)hand.get(index));
        }
    }

    public void setHandChanged(int slot, ItemStack itemStack) {
        if (this.level.f_46443_) {
            return;
        }
        if (this.playerCompanionEntity != null) {
            this.playerCompanionEntity.setHandItem(slot, itemStack);
        } else if (this.dataLoaded && this.playerCompanionData != null) {
            this.playerCompanionData.setHandItem(slot, itemStack);
        }
    }

    public void loadInventory() {
        if (this.level.f_46443_ || this.playerCompanionData == null) {
            return;
        }
        NonNullList<ItemStack> inventory = this.playerCompanionData.getInventoryItems();
        for (int index = 0; index < inventory.size(); ++index) {
            this.inventoryContainer.m_6836_(index, (ItemStack)inventory.get(index));
        }
    }

    public void setInventoryChanged(int slot, ItemStack itemStack) {
        if (this.level.f_46443_) {
            return;
        }
        if (this.dataLoaded && this.playerCompanionData != null) {
            this.playerCompanionData.setInventoryItem(slot, itemStack);
        }
    }

    public Entity getPlayerCompanionEntity() {
        if (this.playerCompanionData == null) {
            return null;
        }
        return this.level.m_6815_(this.playerCompanionData.getEntityId());
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.inventoryContainer.m_6542_(player);
    }
}

