/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.data.PlayerCompanionDataHelper;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.ActionType;
import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionData {
    public static final String UUID_TAG = "UUID";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String ACTIVE_TAG = "Active";
    private static final String ENTITY_ACTION_TYPE = "EntityActionType";
    private static final String ENTITY_AGGRESSION_LEVEL = "EntityAggressionLevel";
    private static final String ENTITY_DATA_TAG = "EntityData";
    private static final String ENTITY_DIMENSION = "EntityDimension";
    private static final String ENTITY_EXPERIENCE_LEVEL_TAG = "EntityExperienceLevel";
    private static final String ENTITY_EXPERIENCE_TAG = "EntityExperience";
    private static final String ENTITY_HEALTH_MAX_TAG = "EntityHealthMax";
    private static final String ENTITY_HEALTH_TAG = "EntityHealth";
    private static final String ENTITY_ID_TAG = "EntityId";
    private static final String ENTITY_ORDERED_TO_POSITION = "EntityOrderedToPosition";
    private static final String ENTITY_RESPAWN_TIMER_TAG = "EntityRespawnTimer";
    private static final String ENTITY_SITTING_ON_SHOULDER_TAG = "EntitySittingOnShoulder";
    private static final String ENTITY_SITTING_TAG = "EntitySitting";
    private static final String ENTITY_TARGET_TAG = "EntityTarget";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String LEVEL_TAG = "Level";
    private static final String NAME_TAG = "Name";
    private static final String OWNER_NAME_TAG = "OwnerName";
    private static final String OWNER_TAG = "Owner";
    private static final String POSITION_TAG = "Position";
    private static final String REMOVED_TAG = "Removed";
    private static final String TYPE_TAG = "Type";
    private ActionType entityActionType = ActionType.UNKNOWN;
    private AggressionLevel entityAggressionLevel = AggressionLevel.UNKNOWN;
    private BlockPos blockPos;
    private ClientLevel clientLevel;
    private CompoundTag entityData;
    private EntityType<?> entityType;
    private NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> inventoryItems = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private PlayerCompanionEntity companionEntity;
    private PlayerCompanionType type = PlayerCompanionType.UNKNOWN;
    private ResourceKey<Level> level;
    private ServerLevel serverLevel;
    private String entityDimension = "";
    private String entityTarget = "";
    private String levelName = "";
    private String name = "";
    private String ownerName = "";
    private UUID companionUUID = null;
    private UUID ownerUUID = null;
    private boolean active = true;
    private boolean entityOrderedToPosition = false;
    private boolean entitySitOnShoulder = false;
    private boolean entitySitting = false;
    private boolean hasOwner = false;
    private boolean isRemoved = false;
    private float entityHealth;
    private float entityHealthMax;
    private int entityExperience = 1;
    private int entityExperienceLevel = 1;
    private int entityId;
    private int entityRespawnTimer;

    public PlayerCompanionData(PlayerCompanionEntity companion) {
        this.load(companion);
    }

    public PlayerCompanionData(CompoundTag compoundTag) {
        this.load(compoundTag);
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public boolean isSittingOnShoulder() {
        return this.entitySitOnShoulder;
    }

    public boolean isOrderedToSit() {
        return this.entitySitting;
    }

    public boolean isOrderedToPosition() {
        return this.entityOrderedToPosition;
    }

    public UUID getUUID() {
        return this.companionUUID;
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwnerUUID() {
        if (this.ownerUUID == null) {
            return null;
        }
        return this.ownerUUID;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public PlayerCompanionType getType() {
        return this.type;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.setDirty();
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public String getDimensionName() {
        return this.entityDimension;
    }

    public int getExperience() {
        return this.entityExperience;
    }

    public int getExperienceLevel() {
        return this.entityExperienceLevel;
    }

    public ActionType getEntityActionType() {
        return this.entityActionType;
    }

    public void setEntityActionType(ActionType actionType) {
        this.entityActionType = actionType;
    }

    public AggressionLevel getEntityAggressionLevel() {
        return this.entityAggressionLevel;
    }

    public void setEntityAggressionLevel(AggressionLevel aggressionLevel) {
        this.entityAggressionLevel = aggressionLevel;
    }

    public PlayerCompanionEntity getPlayerCompanionEntity() {
        if (this.companionEntity == null) {
            Entity entity = null;
            if (this.serverLevel != null && this.companionUUID != null) {
                entity = this.serverLevel.m_8791_(this.companionUUID);
            } else if (this.clientLevel != null && this.entityId > 0) {
                entity = this.clientLevel.m_6815_(this.entityId);
            }
            if (entity instanceof PlayerCompanionEntity) {
                PlayerCompanionEntity playerCompanionEntity;
                this.companionEntity = playerCompanionEntity = (PlayerCompanionEntity)entity;
            }
        }
        return this.companionEntity;
    }

    public float getEntityHealth() {
        return this.entityHealth;
    }

    public float getEntityHealthMax() {
        return this.entityHealthMax;
    }

    public CompoundTag getEntityData() {
        return this.entityData;
    }

    public void syncEntityData(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.syncEntityData(livingEntity);
        }
    }

    public void syncEntityData(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.entityData = livingEntity.serializeNBT();
        }
    }

    public void syncEntityData() {
        PlayerCompanionEntity playerCompanionEntity = this.getPlayerCompanionEntity();
        this.syncEntityData((LivingEntity)playerCompanionEntity);
    }

    public int getEntityRespawnTimer() {
        return this.entityRespawnTimer;
    }

    public String getEntityTarget() {
        return this.entityTarget;
    }

    public boolean hasEntityTarget() {
        return this.entityTarget != null && !this.entityTarget.isBlank();
    }

    public NonNullList<ItemStack> getArmorItems() {
        return this.armorItems;
    }

    public void setArmorItems(NonNullList<ItemStack> armor) {
        this.armorItems = armor;
        this.setDirty();
    }

    public void setArmorItem(int index, ItemStack itemStack) {
        this.armorItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public ItemStack getArmorItem(int index) {
        return (ItemStack)this.armorItems.get(index);
    }

    public int getArmorItemsSize() {
        return this.armorItems.size();
    }

    public NonNullList<ItemStack> getHandItems() {
        return this.handItems;
    }

    public void setHandItems(NonNullList<ItemStack> hand) {
        this.handItems = hand;
        this.setDirty();
    }

    public void setHandItem(int index, ItemStack itemStack) {
        this.handItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public ItemStack getHandItem(int index) {
        return (ItemStack)this.handItems.get(index);
    }

    public int getHandItemsSize() {
        return this.handItems.size();
    }

    public NonNullList<ItemStack> getInventoryItems() {
        return this.inventoryItems;
    }

    public void setInventoryItems(NonNullList<ItemStack> inventory) {
        this.inventoryItems = inventory;
        this.setDirty();
    }

    public void setInventoryItem(int index, ItemStack itemStack) {
        this.inventoryItems.set(index, (Object)itemStack);
        this.setDirty();
    }

    public ItemStack getInventoryItem(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public int getInventoryItemsSize() {
        return this.inventoryItems.size();
    }

    public boolean storeInventoryItem(ItemStack itemStack) {
        if (itemStack.m_41741_() > 1) {
            Item item = itemStack.m_41720_();
            int numberOfItems = itemStack.m_41613_();
            for (int index = 0; index < this.getInventoryItemsSize(); ++index) {
                ItemStack existingItems = this.getInventoryItem(index);
                if (existingItems.m_41619_() || !existingItems.m_150930_(item) || existingItems.m_41613_() + numberOfItems >= existingItems.m_41741_()) continue;
                existingItems.m_41769_(numberOfItems);
                return true;
            }
        }
        for (int index = 0; index < this.getInventoryItemsSize(); ++index) {
            ItemStack existingItems = this.getInventoryItem(index);
            if (!existingItems.m_41619_()) continue;
            this.setInventoryItem(index, itemStack);
            return true;
        }
        return false;
    }

    public boolean hasEntityRespawnTimer() {
        return this.entityRespawnTimer > 0;
    }

    public void load(PlayerCompanionEntity companion) {
        this.companionEntity = companion;
        this.companionUUID = companion.m_20148_();
        this.name = companion.m_8077_() ? companion.m_7770_().getString() : companion.getRandomName();
        this.type = companion.getCompanionType();
        this.hasOwner = companion.hasOwner();
        if (this.hasOwner) {
            this.ownerUUID = companion.m_21805_();
            if (companion.m_269323_() != null) {
                this.ownerName = companion.m_269323_().m_7755_().getString();
            }
        }
        this.blockPos = companion.m_20183_();
        this.level = companion.m_9236_().m_46472_();
        this.levelName = this.level.m_211136_() + "/" + this.level.m_135782_();
        this.entityId = companion.m_19879_();
        this.entityActionType = companion.getActionType();
        this.entityAggressionLevel = companion.getAggressionLevel();
        this.entityDimension = companion.getDimensionName();
        this.entityExperience = companion.getExperience();
        this.entityExperienceLevel = companion.getExperienceLevel();
        this.entityHealth = companion.m_21223_();
        this.entityHealthMax = companion.m_21233_();
        this.entityType = companion.m_6095_();
        this.entityRespawnTimer = companion.getRespawnTimer();
        this.entitySitting = companion.m_21827_();
        this.entityOrderedToPosition = companion.isOrderedToPosition();
        this.entitySitOnShoulder = companion.isSitOnShoulder();
        this.entityData = companion.serializeNBT();
        LivingEntity target = companion.m_5448_();
        this.entityTarget = target == null || target.m_20078_() == null ? "" : target.m_20078_();
        Level companionLevel = companion.m_9236_();
        if (companionLevel != null) {
            if (companionLevel.f_46443_) {
                this.clientLevel = (ClientLevel)companion.m_9236_();
            } else {
                this.serverLevel = (ServerLevel)companion.m_9236_();
            }
        }
        this.setArmorItems((NonNullList<ItemStack>)((NonNullList)companion.m_6168_()));
        this.setHandItems((NonNullList<ItemStack>)((NonNullList)companion.m_6167_()));
        log.debug("Loaded PlayerCompanion {} data over entity with {} and data {}", (Object)this.name, (Object)this, (Object)this.entityData);
    }

    public void load(CompoundTag compoundTag) {
        this.companionUUID = compoundTag.m_128342_(UUID_TAG);
        this.name = compoundTag.m_128461_(NAME_TAG);
        if (compoundTag.m_128441_(TYPE_TAG)) {
            this.type = PlayerCompanionType.valueOf(compoundTag.m_128461_(TYPE_TAG));
        }
        this.hasOwner = compoundTag.m_128403_(OWNER_TAG);
        if (this.hasOwner) {
            this.ownerUUID = compoundTag.m_128342_(OWNER_TAG);
            if (compoundTag.m_128441_(OWNER_NAME_TAG)) {
                this.ownerName = compoundTag.m_128461_(OWNER_NAME_TAG);
            }
        }
        this.active = compoundTag.m_128471_(ACTIVE_TAG);
        this.isRemoved = compoundTag.m_128471_(REMOVED_TAG);
        this.blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(POSITION_TAG));
        if (compoundTag.m_128441_(LEVEL_TAG)) {
            this.levelName = compoundTag.m_128461_(LEVEL_TAG);
            if (this.levelName.contains("/")) {
                String[] levelNameParts = this.levelName.split("/");
                ResourceLocation registryName = new ResourceLocation(levelNameParts[0]);
                ResourceLocation locationName = new ResourceLocation(levelNameParts[1]);
                this.level = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)registryName), (ResourceLocation)locationName);
            }
        }
        if (compoundTag.m_128441_(ENTITY_ID_TAG)) {
            this.entityId = compoundTag.m_128451_(ENTITY_ID_TAG);
        }
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compoundTag.m_128461_(ENTITY_TYPE_TAG)));
        }
        this.entityData = compoundTag.m_128469_(ENTITY_DATA_TAG);
        this.entityDimension = compoundTag.m_128461_(ENTITY_DIMENSION);
        this.entityExperience = compoundTag.m_128451_(ENTITY_EXPERIENCE_TAG);
        this.entityExperienceLevel = compoundTag.m_128451_(ENTITY_EXPERIENCE_LEVEL_TAG);
        this.entityHealth = compoundTag.m_128457_(ENTITY_HEALTH_TAG);
        this.entityHealthMax = compoundTag.m_128457_(ENTITY_HEALTH_MAX_TAG);
        this.entityOrderedToPosition = compoundTag.m_128471_(ENTITY_ORDERED_TO_POSITION);
        this.entityRespawnTimer = compoundTag.m_128451_(ENTITY_RESPAWN_TIMER_TAG);
        this.entitySitting = compoundTag.m_128471_(ENTITY_SITTING_TAG);
        this.entityTarget = compoundTag.m_128461_(ENTITY_TARGET_TAG);
        this.entitySitOnShoulder = compoundTag.m_128471_(ENTITY_SITTING_ON_SHOULDER_TAG);
        if (compoundTag.m_128441_(ENTITY_ACTION_TYPE)) {
            this.entityActionType = ActionType.get(compoundTag.m_128461_(ENTITY_ACTION_TYPE));
        }
        if (compoundTag.m_128441_(ENTITY_AGGRESSION_LEVEL)) {
            this.entityAggressionLevel = AggressionLevel.get(compoundTag.m_128461_(ENTITY_AGGRESSION_LEVEL));
        }
        PlayerCompanionDataHelper.loadArmorItems(compoundTag, this.armorItems);
        PlayerCompanionDataHelper.loadHandItems(compoundTag, this.handItems);
        PlayerCompanionDataHelper.loadInventoryItems(compoundTag, this.inventoryItems);
        log.trace("Loaded PlayerCompanion {} data over compoundTag with {}", (Object)this.name, (Object)this);
    }

    public CompoundTag save(CompoundTag compoundTag) {
        return this.save(compoundTag, true);
    }

    public CompoundTag saveMetaData(CompoundTag compoundTag) {
        return this.save(compoundTag, false);
    }

    public CompoundTag save(CompoundTag compoundTag, boolean includeData) {
        compoundTag.m_128362_(UUID_TAG, this.companionUUID);
        compoundTag.m_128359_(NAME_TAG, this.name);
        compoundTag.m_128359_(TYPE_TAG, this.type.name());
        compoundTag.m_128379_(ACTIVE_TAG, this.active);
        compoundTag.m_128379_(REMOVED_TAG, this.isRemoved);
        compoundTag.m_128365_(POSITION_TAG, (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        if (!this.levelName.isEmpty()) {
            compoundTag.m_128359_(LEVEL_TAG, this.levelName);
        }
        compoundTag.m_128405_(ENTITY_ID_TAG, this.entityId);
        compoundTag.m_128359_(ENTITY_TYPE_TAG, EntityType.m_20613_(this.entityType).toString());
        compoundTag.m_128405_(ENTITY_RESPAWN_TIMER_TAG, this.entityRespawnTimer);
        PlayerCompanionEntity playerCompanionEntity = this.getPlayerCompanionEntity();
        if (playerCompanionEntity != null && playerCompanionEntity.m_6084_()) {
            this.entityData = playerCompanionEntity.serializeNBT();
        }
        if (includeData && this.entityData != null) {
            compoundTag.m_128365_(ENTITY_DATA_TAG, (Tag)this.entityData);
        }
        if (playerCompanionEntity != null && playerCompanionEntity.m_6084_()) {
            LivingEntity target;
            compoundTag.m_128359_(ENTITY_ACTION_TYPE, playerCompanionEntity.getActionType().name());
            compoundTag.m_128359_(ENTITY_AGGRESSION_LEVEL, playerCompanionEntity.getAggressionLevel().name());
            compoundTag.m_128359_(ENTITY_DIMENSION, playerCompanionEntity.getDimensionName());
            compoundTag.m_128379_(ENTITY_SITTING_TAG, playerCompanionEntity.m_21827_());
            compoundTag.m_128379_(ENTITY_SITTING_ON_SHOULDER_TAG, playerCompanionEntity.isSitOnShoulder());
            compoundTag.m_128379_(ENTITY_ORDERED_TO_POSITION, playerCompanionEntity.isOrderedToPosition());
            compoundTag.m_128350_(ENTITY_HEALTH_MAX_TAG, playerCompanionEntity.m_21233_());
            compoundTag.m_128350_(ENTITY_HEALTH_TAG, playerCompanionEntity.m_21223_());
            compoundTag.m_128405_(ENTITY_EXPERIENCE_LEVEL_TAG, playerCompanionEntity.getExperienceLevel());
            compoundTag.m_128405_(ENTITY_EXPERIENCE_TAG, playerCompanionEntity.getExperience());
            LivingEntity owner = playerCompanionEntity.m_269323_();
            if (owner != null) {
                compoundTag.m_128362_(OWNER_TAG, owner.m_20148_());
                compoundTag.m_128359_(OWNER_NAME_TAG, owner.m_7755_().getString());
            }
            compoundTag.m_128359_(ENTITY_TARGET_TAG, (target = playerCompanionEntity.m_5448_()) == null || target.m_20078_() == null ? "" : target.m_20078_());
            this.setArmorItems((NonNullList<ItemStack>)((NonNullList)playerCompanionEntity.m_6168_()));
            this.setHandItems((NonNullList<ItemStack>)((NonNullList)playerCompanionEntity.m_6167_()));
        } else {
            compoundTag.m_128359_(ENTITY_ACTION_TYPE, this.entityActionType.name());
            compoundTag.m_128359_(ENTITY_AGGRESSION_LEVEL, this.entityAggressionLevel.name());
            compoundTag.m_128359_(ENTITY_DIMENSION, this.entityDimension);
            compoundTag.m_128379_(ENTITY_SITTING_TAG, this.entitySitting);
            compoundTag.m_128379_(ENTITY_SITTING_ON_SHOULDER_TAG, this.entitySitOnShoulder);
            compoundTag.m_128379_(ENTITY_ORDERED_TO_POSITION, this.entityOrderedToPosition);
            compoundTag.m_128350_(ENTITY_HEALTH_MAX_TAG, this.entityHealthMax);
            compoundTag.m_128350_(ENTITY_HEALTH_TAG, this.entityHealth);
            compoundTag.m_128405_(ENTITY_EXPERIENCE_LEVEL_TAG, this.entityExperienceLevel);
            compoundTag.m_128405_(ENTITY_EXPERIENCE_TAG, this.entityExperience);
            if (this.ownerUUID != null) {
                compoundTag.m_128362_(OWNER_TAG, this.ownerUUID);
                compoundTag.m_128359_(OWNER_NAME_TAG, this.ownerName);
            }
            compoundTag.m_128359_(ENTITY_TARGET_TAG, this.entityTarget == null ? "" : this.entityTarget);
        }
        PlayerCompanionDataHelper.saveArmorItems(compoundTag, this.armorItems);
        PlayerCompanionDataHelper.saveHandItems(compoundTag, this.handItems);
        PlayerCompanionDataHelper.saveInventoryItems(compoundTag, this.inventoryItems);
        return compoundTag;
    }

    public String toString() {
        return "PlayerCompanion['" + this.name + "', type=" + this.type + ", owner=" + this.ownerUUID + "(" + this.ownerName + "), entity=" + this.entityType + ", experience=" + this.entityExperience + ", level=" + this.entityExperienceLevel + ", health=" + this.entityHealth + "/" + this.entityHealthMax + ", x=" + this.blockPos.m_123341_() + ", y=" + this.blockPos.m_123342_() + ", z=" + this.blockPos.m_123343_() + ", armor=" + this.getArmorItems() + ", hand=" + this.getHandItems() + ", dimension=" + this.entityDimension + ", action_type = " + this.entityActionType.name() + ", aggression_level= " + this.entityAggressionLevel.name() + ", respawnTimer=" + this.entityRespawnTimer + ", id=" + this.entityId + ", UUID=" + this.companionUUID + "]";
    }

    private void setDirty() {
        PlayerCompanionsServerData serverData = PlayerCompanionsServerData.get();
        if (serverData != null) {
            serverData.m_77762_();
        }
    }

    public boolean is(PlayerCompanionData playerCompanion) {
        return this.companionUUID == playerCompanion.companionUUID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlayerCompanionData)) {
            return false;
        }
        PlayerCompanionData playerCompanion = (PlayerCompanionData)object;
        return playerCompanion.getUUID().equals(this.companionUUID);
    }

    public int hashCode() {
        return this.companionUUID.hashCode();
    }
}

