/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionDataHelper {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");

    protected PlayerCompanionDataHelper() {
    }

    public static CompoundTag saveArmorItems(CompoundTag compoundTag, NonNullList<ItemStack> armor) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < armor.size(); ++i) {
            ItemStack itemStack = (ItemStack)armor.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTagSlot = new CompoundTag();
            compoundTagSlot.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(compoundTagSlot);
            listTag.add((Object)compoundTagSlot);
        }
        if (!listTag.isEmpty()) {
            compoundTag.m_128365_("Armor", (Tag)listTag);
        }
        return compoundTag;
    }

    public static void loadArmorItems(CompoundTag compoundTag, NonNullList<ItemStack> armor) {
        PlayerCompanionDataHelper.resetNonNullList(armor);
        ListTag listTag = compoundTag.m_128437_("Armor", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTagSlot = listTag.m_128728_(i);
            int index = compoundTagSlot.m_128445_("Slot") & 0xFF;
            if (index < 0 || index >= armor.size()) continue;
            armor.set(index, (Object)ItemStack.m_41712_((CompoundTag)compoundTagSlot));
        }
    }

    public static CompoundTag saveInventoryItems(CompoundTag compoundTag, NonNullList<ItemStack> inventory) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemStack = (ItemStack)inventory.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTagSlot = new CompoundTag();
            compoundTagSlot.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(compoundTagSlot);
            listTag.add((Object)compoundTagSlot);
        }
        if (!listTag.isEmpty()) {
            compoundTag.m_128365_("Inventory", (Tag)listTag);
        }
        return compoundTag;
    }

    public static void loadInventoryItems(CompoundTag compoundTag, NonNullList<ItemStack> inventory) {
        PlayerCompanionDataHelper.resetNonNullList(inventory);
        ListTag listTag = compoundTag.m_128437_("Inventory", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTagSlot = listTag.m_128728_(i);
            int index = compoundTagSlot.m_128445_("Slot") & 0xFF;
            if (index < 0 || index >= inventory.size()) continue;
            inventory.set(index, (Object)ItemStack.m_41712_((CompoundTag)compoundTagSlot));
        }
    }

    public static CompoundTag saveHandItems(CompoundTag compoundTag, NonNullList<ItemStack> hand) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < hand.size(); ++i) {
            ItemStack itemStack = (ItemStack)hand.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTagSlot = new CompoundTag();
            compoundTagSlot.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(compoundTagSlot);
            listTag.add((Object)compoundTagSlot);
        }
        if (!listTag.isEmpty()) {
            compoundTag.m_128365_("Hand", (Tag)listTag);
        }
        return compoundTag;
    }

    public static void loadHandItems(CompoundTag compoundTag, NonNullList<ItemStack> hand) {
        PlayerCompanionDataHelper.resetNonNullList(hand);
        ListTag listTag = compoundTag.m_128437_("Hand", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTagSlot = listTag.m_128728_(i);
            int index = compoundTagSlot.m_128445_("Slot") & 0xFF;
            if (index < 0 || index >= hand.size()) continue;
            hand.set(index, (Object)ItemStack.m_41712_((CompoundTag)compoundTagSlot));
        }
    }

    private static void resetNonNullList(NonNullList<ItemStack> list) {
        Collections.fill(list, ItemStack.f_41583_);
    }
}

