/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerCompanionManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final short SYNC_TICK = 25;
    private static final Set<Entity> entitySet = ConcurrentHashMap.newKeySet();
    private static short ticks = 0;

    protected PlayerCompanionManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        log.info("{} Player Companion Data Manager ...", (Object)"\ud83d\udc7e Register Player Companions");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityJoinLevelEvent(EntityJoinLevelEvent event) {
        PlayerCompanionManager.updateOrRegisterCompanion(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityTeleportEvent(EntityTeleportEvent event) {
        PlayerCompanionManager.updateOrRegisterCompanion(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        PlayerCompanionManager.updateOrRegisterCompanion(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleEntityLeaveLevelEvent(EntityLeaveLevelEvent event) {
        PlayerCompanionEntity playerCompanionEntity;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerCompanionEntity && ((playerCompanionEntity = (PlayerCompanionEntity)entity).canRespawnOnDeath() || playerCompanionEntity.m_146911_() != Entity.RemovalReason.KILLED)) {
            PlayerCompanionManager.updateCompanionData(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingDamageEvent(LivingDamageEvent event) {
        PlayerCompanionManager.scheduleCompanionDataUpdate((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        PlayerCompanionManager.scheduleCompanionDataUpdate((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingHealEvent(LivingHealEvent event) {
        PlayerCompanionManager.scheduleCompanionDataUpdate((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        PlayerCompanionEntity playerCompanionEntity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)livingEntity).canRespawnOnDeath()) {
            PlayerCompanionManager.updateCompanionData((Entity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 25) {
                PlayerCompanionManager.syncCompanionData();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent
    public static void handlePlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerCompanionManager.verifyPlayerCompanionForPlayer(event.getEntity());
        PlayerCompanionManager.syncPlayerCompanionsDataToPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerCompanionManager.syncPlayerCompanionsDataToPlayer(event.getEntity());
    }

    private static void scheduleCompanionDataUpdate(Entity entity) {
        PlayerCompanionEntity playerCompanionEntity;
        if (entity instanceof PlayerCompanionEntity && (playerCompanionEntity = (PlayerCompanionEntity)entity).hasOwner()) {
            entitySet.add(entity);
        }
    }

    private static void syncCompanionData() {
        if (entitySet.isEmpty()) {
            return;
        }
        log.debug("Sync data for {} companions with: {}", (Object)entitySet.size(), entitySet);
        Iterator<Entity> entityIterator = entitySet.iterator();
        while (entityIterator.hasNext()) {
            Entity entity = entityIterator.next();
            if (entity != null) {
                PlayerCompanionManager.updateOrRegisterCompanion(entity);
            }
            entityIterator.remove();
        }
    }

    private static void syncPlayerCompanionsDataToPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerCompanionsServerData.get().syncPlayerCompanionsData(serverPlayer.m_20148_());
        }
    }

    private static void updateOrRegisterCompanion(Entity entity) {
        if (entity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            if (!playerCompanionEntity.m_9236_().f_46443_ && playerCompanionEntity.hasOwner() && (playerCompanionEntity.canRespawnOnDeath() || playerCompanionEntity.m_146911_() != Entity.RemovalReason.KILLED)) {
                log.debug("Update or register Companion {}", (Object)entity);
                PlayerCompanionsServerData.get().updateOrRegisterCompanion(playerCompanionEntity);
            }
        }
    }

    private static void updateCompanionData(Entity entity) {
        if (entity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            if (!playerCompanionEntity.m_9236_().f_46443_ && playerCompanionEntity.hasOwner() && (playerCompanionEntity.canRespawnOnDeath() || playerCompanionEntity.m_146911_() != Entity.RemovalReason.KILLED)) {
                log.debug("Update Companion Data {}", (Object)entity);
                PlayerCompanionsServerData.get().updatePlayerCompanionData(playerCompanionEntity);
            }
        }
    }

    private static void verifyPlayerCompanionForPlayer(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerCompanionsServerData data = PlayerCompanionsServerData.get();
        if (data == null) {
            return;
        }
        MinecraftServer server = serverPlayer.m_20194_();
        if (server == null) {
            return;
        }
        Set<Entity> playerCompanionsEntityInOwnersDimension = data.getCompanionsEntity(player.m_20148_(), serverPlayer.m_9236_());
        if (playerCompanionsEntityInOwnersDimension.isEmpty()) {
            return;
        }
        for (ServerLevel serverLevel : server.m_129785_()) {
            if (serverLevel == null || serverPlayer.m_9236_() == serverLevel) continue;
            for (Entity playerCompanionEntity : playerCompanionsEntityInOwnersDimension) {
                Entity entity = serverLevel.m_8791_(playerCompanionEntity.m_20148_());
                if (entity == null || entity.m_213877_()) continue;
                entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        }
    }
}

