/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionsClientData {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final ConcurrentHashMap<UUID, PlayerCompanionData> playerCompanionsMap = new ConcurrentHashMap();

    protected PlayerCompanionsClientData() {
    }

    public static PlayerCompanionData getCompanion(ItemStack itemStack) {
        UUID companionUUID = null;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128403_("CompanionUUID")) {
            companionUUID = compoundTag.m_128342_("CompanionUUID");
        }
        if (companionUUID != null) {
            return PlayerCompanionsClientData.getCompanion(companionUUID);
        }
        return null;
    }

    public static PlayerCompanionData getCompanion(UUID companionUUID) {
        return playerCompanionsMap.get(companionUUID);
    }

    public static PlayerCompanionData getCompanion(LivingEntity livingEntity) {
        if (livingEntity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity companionEntity = (PlayerCompanionEntity)livingEntity;
            return playerCompanionsMap.get(companionEntity.m_20148_());
        }
        return null;
    }

    public static Set<PlayerCompanionData> getCompanions() {
        return new HashSet<PlayerCompanionData>(playerCompanionsMap.values());
    }

    public static void load(String data) {
        CompoundTag compoundTag;
        try {
            compoundTag = TagParser.m_129359_((String)data);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
        }
        if (compoundTag != null) {
            PlayerCompanionsClientData.load(compoundTag);
        }
    }

    public static void load(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("Companions")) {
            ListTag companionListTag = compoundTag.m_128437_("Companions", 10);
            for (int i = 0; i < companionListTag.size(); ++i) {
                PlayerCompanionsClientData.loadPlayerCompanionData(companionListTag.m_128728_(i));
            }
        } else if (compoundTag.m_128441_("UUID")) {
            PlayerCompanionsClientData.loadPlayerCompanionData(compoundTag);
        } else {
            log.error("Unable to load Player Companion data from {}!", (Object)compoundTag);
        }
    }

    public static void loadPlayerCompanionData(String data) {
        CompoundTag compoundTag;
        try {
            compoundTag = TagParser.m_129359_((String)data);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new JsonSyntaxException("Invalid NBT tag: " + commandSyntaxException.getMessage());
        }
        PlayerCompanionsClientData.loadPlayerCompanionData(compoundTag);
    }

    public static void loadPlayerCompanionData(CompoundTag compoundTag) {
        if (compoundTag != null) {
            UUID companionUUID = compoundTag.m_128342_("UUID");
            if (companionUUID == null) {
                log.error("Unable to get valid UUID for {}", (Object)compoundTag);
                return;
            }
            PlayerCompanionData playerCompanionData = playerCompanionsMap.get(companionUUID);
            if (playerCompanionData != null) {
                log.debug("Update client player companion data for {} with {}", (Object)companionUUID, (Object)compoundTag);
                playerCompanionData.load(compoundTag);
            } else {
                log.debug("Register client player companion data for {} with {}", (Object)companionUUID, (Object)compoundTag);
                PlayerCompanionData playerCompanion = new PlayerCompanionData(compoundTag);
                PlayerCompanionsClientData.loadPlayerCompanionData(playerCompanion);
            }
        }
    }

    public static void loadPlayerCompanionData(PlayerCompanionData playerCompanion) {
        if (playerCompanion != null) {
            playerCompanionsMap.put(playerCompanion.getUUID(), playerCompanion);
        }
    }
}

