/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.UUID;

public interface PlayerCompanionsDataSync {
    public PlayerCompanionEntity getSyncReference();

    public boolean getDataSyncNeeded();

    public void setDataSyncNeeded(boolean var1);

    default public boolean hasSyncReference() {
        return this.getSyncReference() != null;
    }

    default public void syncData() {
        if (this.hasSyncReference()) {
            this.syncData(this.getSyncReference());
            this.setDataSyncNeeded(false);
        }
    }

    default public void registerData() {
        if (this.hasSyncReference()) {
            this.registerData(this.getSyncReference());
            this.setDataSyncNeeded(false);
        }
    }

    default public boolean syncDataIfNeeded() {
        if (this.getDataSyncNeeded()) {
            this.syncData();
            return true;
        }
        return false;
    }

    default public void syncData(PlayerCompanionEntity playerCompanionEntity) {
        PlayerCompanionsServerData serverData = this.getServerData();
        if (serverData != null) {
            serverData.updateOrRegisterCompanion(playerCompanionEntity);
        }
    }

    default public void registerData(PlayerCompanionEntity playerCompanionEntity) {
        PlayerCompanionsServerData serverData = this.getServerData();
        if (serverData != null) {
            serverData.registerCompanion(playerCompanionEntity);
        }
    }

    default public PlayerCompanionData getData(UUID uuid) {
        PlayerCompanionsServerData serverData = this.getServerData();
        if (serverData == null || uuid == null) {
            return null;
        }
        return serverData.getCompanion(uuid);
    }

    default public PlayerCompanionsServerData getServerData() {
        return PlayerCompanionsServerData.get();
    }
}

