/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerDataBackup;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerDataClientSync;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerCompanionsServerData
extends SavedData {
    public static final String COMPANIONS_TAG = "Companions";
    public static final String NPC_TAG = "NPCs";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final String PLAYER_COMPANIONS_FILE_ID = "player_companions";
    private static ConcurrentHashMap<UUID, PlayerCompanionData> playerCompanionsMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<UUID, Set<PlayerCompanionData>> companionsPerPlayerMap = new ConcurrentHashMap();
    private static MinecraftServer server;
    private static PlayerCompanionsServerData data;
    private static long nextBackupTime;

    public PlayerCompanionsServerData() {
        this.m_77762_();
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        playerCompanionsMap = new ConcurrentHashMap();
        companionsPerPlayerMap = new ConcurrentHashMap();
        if (Boolean.TRUE.equals(PlayerCompanionsServerData.COMMON.dataBackupEnabled.get())) {
            nextBackupTime = Instant.now().getEpochSecond() + 60L * (long)((Integer)PlayerCompanionsServerData.COMMON.dataBackupInterval.get()).intValue();
            log.info("Enable automatic data backups every {} minutes, next backup will run at {} ...", PlayerCompanionsServerData.COMMON.dataBackupInterval.get(), (Object)nextBackupTime);
        } else {
            log.warn("Automatic Data backups are deactivated, please make sure to create regular backups!");
        }
    }

    public static void prepare(MinecraftServer server) {
        if (server == null || server == PlayerCompanionsServerData.server && data != null) {
            return;
        }
        log.info("{} preparing data for {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)server);
        PlayerCompanionsServerData.server = server;
        data = (PlayerCompanionsServerData)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(PlayerCompanionsServerData::load, PlayerCompanionsServerData::new, PlayerCompanionsServerData.getFileId());
    }

    public static void setData(PlayerCompanionsServerData data) {
        PlayerCompanionsServerData.data = data;
        PlayerCompanionsServerData.data.m_77762_();
    }

    public static boolean available() {
        PlayerCompanionsServerData.get();
        return data != null;
    }

    public static PlayerCompanionsServerData get() {
        if (data == null) {
            PlayerCompanionsServerData.prepare(ServerLifecycleHooks.getCurrentServer());
        }
        return data;
    }

    public static String getFileId() {
        return PLAYER_COMPANIONS_FILE_ID;
    }

    private static void addPlayerCompanion(PlayerCompanionData playerCompanion) {
        playerCompanionsMap.put(playerCompanion.getUUID(), playerCompanion);
        UUID ownerUUID = playerCompanion.getOwnerUUID();
        if (ownerUUID != null) {
            Set playerCompanions = companionsPerPlayerMap.computeIfAbsent(ownerUUID, key -> ConcurrentHashMap.newKeySet());
            playerCompanions.remove(playerCompanion);
            playerCompanions.add(playerCompanion);
        }
    }

    private static void addPlayerCompanion(CompoundTag compoundTag) {
        PlayerCompanionsServerData.addPlayerCompanion(new PlayerCompanionData(compoundTag));
    }

    public static PlayerCompanionsServerData load(CompoundTag compoundTag) {
        if (Boolean.TRUE.equals(PlayerCompanionsServerData.COMMON.dataBackupEnabled.get())) {
            PlayerCompanionsServerDataBackup.saveBackup(compoundTag);
            if ((Integer)PlayerCompanionsServerData.COMMON.dataBackupInterval.get() > 0) {
                PlayerCompanionsServerData.updateBackupTime(Instant.now().getEpochSecond() + 60L * (long)((Integer)PlayerCompanionsServerData.COMMON.dataBackupInterval.get()).intValue());
            }
        }
        PlayerCompanionsServerData playerCompanionsData = new PlayerCompanionsServerData();
        log.info("{} loading data ...", (Object)"\ud83d\udc7e Bo's Player Companions");
        if (compoundTag.m_128441_(COMPANIONS_TAG)) {
            ListTag companionListTag = compoundTag.m_128437_(COMPANIONS_TAG, 10);
            for (int i = 0; i < companionListTag.size(); ++i) {
                PlayerCompanionsServerData.addPlayerCompanion(companionListTag.m_128728_(i));
            }
        }
        return playerCompanionsData;
    }

    private static void updateBackupTime(long backupTime) {
        if (nextBackupTime != backupTime && backupTime > 0L && backupTime >= Instant.now().getEpochSecond()) {
            log.info("{} next planned backup is scheduled for {} in about {} min.", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)backupTime, (Object)((backupTime - Instant.now().getEpochSecond()) / 60L));
            nextBackupTime = backupTime;
        }
    }

    public PlayerCompanionData getCompanion(ItemStack itemStack) {
        UUID companionUUID = null;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128403_("CompanionUUID")) {
            companionUUID = compoundTag.m_128342_("CompanionUUID");
        }
        if (companionUUID != null) {
            return this.getCompanion(companionUUID);
        }
        return null;
    }

    public boolean hasCompanion(ItemStack itemStack) {
        return this.getCompanion(itemStack) != null;
    }

    public PlayerCompanionData getCompanion(PlayerCompanionEntity playerCompanionEntity) {
        return this.getCompanion(playerCompanionEntity.m_20148_());
    }

    public PlayerCompanionData getCompanion(UUID companionUUID) {
        return playerCompanionsMap.get(companionUUID);
    }

    public Entity getCompanionEntity(UUID companionUUID, ServerLevel serverLevel) {
        PlayerCompanionData playerCompanionData = this.getCompanion(companionUUID);
        if (playerCompanionData != null && serverLevel != null) {
            return serverLevel.m_8791_(playerCompanionData.getUUID());
        }
        return null;
    }

    public Map<UUID, PlayerCompanionData> getCompanions() {
        return playerCompanionsMap;
    }

    public Set<PlayerCompanionData> getCompanions(UUID ownerUUID) {
        return companionsPerPlayerMap.get(ownerUUID);
    }

    public int getNumberOfCompanions(ServerPlayer serverPlayer) {
        return this.getNumberOfCompanions(serverPlayer.m_20148_());
    }

    public int getNumberOfCompanions(UUID ownerUUID) {
        Set<PlayerCompanionData> playerCompanions = this.getCompanions(ownerUUID);
        if (playerCompanions != null) {
            return playerCompanions.size();
        }
        return 0;
    }

    public Set<Entity> getCompanionsEntity(UUID ownerUUID, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.getCompanionsEntity(ownerUUID, serverLevel);
        }
        return new HashSet<Entity>();
    }

    public Set<Entity> getCompanionsEntity(UUID ownerUUID, ServerLevel serverLevel) {
        HashSet<Entity> result = new HashSet<Entity>();
        Set<PlayerCompanionData> playerCompanionsData = this.getCompanions(ownerUUID);
        if (playerCompanionsData != null) {
            for (PlayerCompanionData playerCompanionData : playerCompanionsData) {
                Entity entity = this.getCompanionEntity(playerCompanionData.getUUID(), serverLevel);
                if (entity == null) continue;
                result.add(entity);
            }
        }
        return result;
    }

    public void updateOrRegisterCompanion(PlayerCompanionEntity companionEntity) {
        if (playerCompanionsMap.get(companionEntity.m_20148_()) == null) {
            this.registerCompanion(companionEntity);
        } else {
            this.updatePlayerCompanion(companionEntity);
        }
    }

    public PlayerCompanionData updatePlayerCompanion(PlayerCompanionEntity companionEntity) {
        PlayerCompanionData playerCompanion = playerCompanionsMap.get(companionEntity.m_20148_());
        if (playerCompanion == null) {
            log.error("Failed to update player companion {} because it does not exists!", (Object)companionEntity);
            this.registerCompanion(companionEntity);
            return null;
        }
        playerCompanion.load(companionEntity);
        UUID ownerUUID = playerCompanion.getOwnerUUID();
        if (ownerUUID != null) {
            Set playerCompanions = companionsPerPlayerMap.computeIfAbsent(ownerUUID, key -> ConcurrentHashMap.newKeySet());
            playerCompanions.remove(playerCompanion);
            playerCompanions.add(playerCompanion);
        }
        this.m_77762_();
        this.syncPlayerCompanionData(playerCompanion);
        return playerCompanion;
    }

    public void updatePlayerCompanionData(PlayerCompanionEntity companionEntity) {
        if (companionEntity.m_19879_() > 1) {
            this.updatePlayerCompanion(companionEntity);
        }
    }

    public PlayerCompanionData registerCompanion(PlayerCompanionEntity companionEntity) {
        return this.registerCompanion(companionEntity, true);
    }

    public PlayerCompanionData registerCompanion(PlayerCompanionEntity companionEntity, boolean requiredOwner) {
        if (playerCompanionsMap.get(companionEntity.m_20148_()) != null) {
            log.warn("Companion {} is already registered!", (Object)companionEntity);
            return playerCompanionsMap.get(companionEntity.m_20148_());
        }
        if (requiredOwner && !companionEntity.hasOwner()) {
            log.debug("Skipping companion {} for registration because it has no owner, yet!", (Object)companionEntity);
            return null;
        }
        if (companionEntity.hasOwner()) {
            log.info("Register companion {} for {} ...", (Object)companionEntity, (Object)companionEntity.m_269323_());
        }
        PlayerCompanionData playerCompanion = new PlayerCompanionData(companionEntity);
        PlayerCompanionsServerData.addPlayerCompanion(playerCompanion);
        this.m_77762_();
        if (playerCompanion.hasOwner()) {
            this.syncPlayerCompanionData(playerCompanion);
        }
        return playerCompanion;
    }

    public void unregisterCompanion(PlayerCompanionEntity companionEntity) {
        PlayerCompanionData playerCompanion = playerCompanionsMap.remove(companionEntity.m_20148_());
        if (playerCompanion != null) {
            log.info("Unregister Player Companion {} ...", (Object)playerCompanion.getUUID());
            UUID ownerUUID = playerCompanion.getOwnerUUID();
            if (ownerUUID != null) {
                Set<PlayerCompanionData> playerCompanions = companionsPerPlayerMap.get(ownerUUID);
                if (playerCompanions != null) {
                    log.info("Unregister Player Companion {} from owner {} ...", (Object)playerCompanion.getUUID(), (Object)ownerUUID);
                    playerCompanions.remove(playerCompanion);
                }
                this.syncPlayerCompanionsData(ownerUUID);
            }
            this.m_77762_();
        }
    }

    public void syncPlayerCompanionsData(UUID ownerUUID) {
        if (ownerUUID == null) {
            return;
        }
        Set<PlayerCompanionData> playerCompanionsData = this.getCompanions(ownerUUID);
        PlayerCompanionsServerDataClientSync.syncPlayerCompanionData(ownerUUID, playerCompanionsData);
    }

    public void syncPlayerCompanionData(PlayerCompanionData playerCompanionData) {
        PlayerCompanionsServerDataClientSync.syncPlayerCompanionData(playerCompanionData);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        log.info("{} saving data ... {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)this);
        ListTag companionListTag = new ListTag();
        for (PlayerCompanionData playerCompanion : playerCompanionsMap.values()) {
            if (playerCompanion == null) continue;
            CompoundTag playerCompanionCompoundTag = new CompoundTag();
            playerCompanion.save(playerCompanionCompoundTag);
            companionListTag.add((Object)playerCompanionCompoundTag);
        }
        compoundTag.m_128365_(COMPANIONS_TAG, (Tag)companionListTag);
        ListTag npcListTag = new ListTag();
        compoundTag.m_128365_(NPC_TAG, (Tag)npcListTag);
        if (Boolean.TRUE.equals(PlayerCompanionsServerData.COMMON.dataBackupEnabled.get()) && nextBackupTime > 0L && Instant.now().getEpochSecond() >= nextBackupTime) {
            PlayerCompanionsServerDataBackup.saveBackup(compoundTag);
            PlayerCompanionsServerData.updateBackupTime(Instant.now().getEpochSecond() + 60L * (long)((Integer)PlayerCompanionsServerData.COMMON.dataBackupInterval.get()).intValue());
        }
        return compoundTag;
    }

    static {
        nextBackupTime = 0L;
    }
}

