/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionsServerDataBackup {
    public static final File BACKUP_FOLDER = new File(ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).toFile(), "player_companions");
    public static final String BACKUP_FILE_NAME = "player_companions_data.nbt";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static CompoundTag lastBackupCompoundTag = null;

    protected PlayerCompanionsServerDataBackup() {
    }

    public static boolean saveBackup() {
        CompoundTag compoundTag = new CompoundTag();
        PlayerCompanionsServerData.get().m_7176_(compoundTag);
        return PlayerCompanionsServerDataBackup.saveBackup(compoundTag);
    }

    public static boolean saveBackup(CompoundTag compoundTag) {
        if (compoundTag.equals((Object)lastBackupCompoundTag)) {
            log.warn("{} skipping Backup, because data are already saved!", (Object)"\ud83d\udc7e Bo's Player Companions");
            return false;
        }
        if (compoundTag.m_128456_() || compoundTag.m_128440_() == 0) {
            log.warn("{} skipping Backup, because data are empty!", (Object)"\ud83d\udc7e Bo's Player Companions");
            return false;
        }
        File file = new File(BACKUP_FOLDER.getAbsoluteFile(), new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-player_companions_data.nbt");
        log.info("{} creating Backup {} ...", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file.getName());
        try {
            if (!file.getParentFile().exists()) {
                log.info("{} creating backup folder at {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file.getParentFile());
                file.getParentFile().mkdirs();
            }
            NbtIo.m_128944_((CompoundTag)compoundTag, (File)file);
            log.info("{} saved backup at {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            lastBackupCompoundTag = compoundTag;
            return true;
        }
        catch (IOException exception) {
            log.error("{} failed save backup with exception: {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)exception);
            return false;
        }
    }

    public static boolean loadBackup(String fileName) {
        File file = new File(BACKUP_FOLDER.getAbsoluteFile(), fileName);
        if (!file.exists()) {
            log.error("{} unable to read backup file from {}!", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            return false;
        }
        CompoundTag compoundTag = PlayerCompanionsServerDataBackup.loadBackup(file);
        if (compoundTag == null) {
            log.warn("{} loaded backup from {} was empty!", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            return false;
        }
        PlayerCompanionsServerData.setData(PlayerCompanionsServerData.load(compoundTag));
        return true;
    }

    public static CompoundTag loadBackup(File file) {
        if (file == null || !file.exists()) {
            log.error("{} unable to read backup file from {}!", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            return null;
        }
        try {
            CompoundTag compoundTag = NbtIo.m_128937_((File)file);
            if (compoundTag == null) {
                log.warn("{} loaded backup from {} was empty!", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            } else {
                log.info("{} loaded backup from {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)file);
            }
            return compoundTag;
        }
        catch (IOException exception) {
            log.error("{} failed load backup with exception: {}", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)exception);
            return null;
        }
    }

    public static List<File> listBackup() {
        File[] files;
        ArrayList<File> backupFiles = new ArrayList<File>();
        if (!BACKUP_FOLDER.exists()) {
            log.error("{} unable to find backup folder {}!", (Object)"\ud83d\udc7e Bo's Player Companions", (Object)BACKUP_FOLDER);
            return backupFiles;
        }
        for (File file : files = BACKUP_FOLDER.listFiles()) {
            if (!file.getName().endsWith(BACKUP_FILE_NAME)) continue;
            backupFiles.add(file);
        }
        return backupFiles;
    }
}

