/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.data;

import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.network.NetworkHandler;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PlayerCompanionsServerDataClientSync {
    protected PlayerCompanionsServerDataClientSync() {
    }

    public static void syncPlayerCompanionData(PlayerCompanionData playerCompanionData) {
        if (playerCompanionData == null || !playerCompanionData.hasOwner()) {
            return;
        }
        CompoundTag data = PlayerCompanionsServerDataClientSync.exportPlayerCompanionData(playerCompanionData);
        UUID playerCompanionUUID = playerCompanionData.getUUID();
        UUID ownerUUID = playerCompanionData.getOwnerUUID();
        NetworkHandler.updatePlayerCompanionData(playerCompanionUUID, ownerUUID, data);
    }

    public static void syncPlayerCompanionData(UUID ownerUUID, Set<PlayerCompanionData> playerCompanionsData) {
        if (ownerUUID == null || playerCompanionsData == null || playerCompanionsData.isEmpty()) {
            return;
        }
        CompoundTag data = PlayerCompanionsServerDataClientSync.exportPlayerCompanionsData(playerCompanionsData);
        NetworkHandler.updatePlayerCompanionsData(ownerUUID, data);
    }

    public static String exportPlayerCompanionDataString(PlayerCompanionData playerCompanionData) {
        CompoundTag compoundTag = PlayerCompanionsServerDataClientSync.exportPlayerCompanionData(playerCompanionData);
        return compoundTag != null && !compoundTag.m_128456_() ? compoundTag.m_7916_() : "";
    }

    public static CompoundTag exportPlayerCompanionData(PlayerCompanionData playerCompanionData) {
        if (playerCompanionData == null || playerCompanionData.getUUID() == null || playerCompanionData.getOwnerUUID() == null) {
            return null;
        }
        CompoundTag compoundTag = new CompoundTag();
        playerCompanionData.saveMetaData(compoundTag);
        return compoundTag;
    }

    public static String exportPlayerCompanionsDataString(Set<PlayerCompanionData> playerCompanionsData) {
        CompoundTag compoundTag = PlayerCompanionsServerDataClientSync.exportPlayerCompanionsData(playerCompanionsData);
        return compoundTag != null && !compoundTag.m_128456_() ? compoundTag.m_7916_() : "";
    }

    public static CompoundTag exportPlayerCompanionsData(Set<PlayerCompanionData> playerCompanionsData) {
        if (playerCompanionsData == null || playerCompanionsData.isEmpty()) {
            return null;
        }
        CompoundTag compoundTag = new CompoundTag();
        ListTag companionListTag = new ListTag();
        for (PlayerCompanionData playerCompanion : playerCompanionsData) {
            if (playerCompanion == null) continue;
            CompoundTag playerCompanionCompoundTag = new CompoundTag();
            playerCompanion.saveMetaData(playerCompanionCompoundTag);
            companionListTag.add((Object)playerCompanionCompoundTag);
        }
        compoundTag.m_128365_("Companions", (Tag)companionListTag);
        return compoundTag;
    }
}

