/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public interface PlayerCompanionAttributes {
    public static final Set<AggressionLevel> aggressionDefaultLevels = Collections.unmodifiableSet(EnumSet.allOf(AggressionLevel.class));

    default public Set<AggressionLevel> getAggressionLevels() {
        return aggressionDefaultLevels;
    }

    default public AggressionLevel getNextAggressionLevel(AggressionLevel aggressionLevel) {
        Iterator<AggressionLevel> iterator = this.getAggressionLevels().iterator();
        while (iterator.hasNext()) {
            AggressionLevel aggressionLevelCurrent = iterator.next();
            if (!aggressionLevel.equals((Object)aggressionLevelCurrent) || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return aggressionLevel;
    }

    default public AggressionLevel getPreviousAggressionLevel(AggressionLevel aggressionLevel) {
        Iterator<AggressionLevel> iterator = this.getAggressionLevels().iterator();
        AggressionLevel aggressionLevelPrevious = null;
        while (iterator.hasNext()) {
            AggressionLevel aggressionLevelCurrent = iterator.next();
            if (aggressionLevel.equals((Object)aggressionLevelCurrent) && aggressionLevelPrevious != null) {
                return aggressionLevelPrevious;
            }
            aggressionLevelPrevious = aggressionLevelCurrent;
        }
        return aggressionLevel;
    }

    default public AggressionLevel getDefaultAggressionLevel() {
        return AggressionLevel.NEUTRAL;
    }

    default public AggressionLevel getFirstAggressionLevel() {
        Optional aggressionLevel;
        Set<AggressionLevel> aggressionLevels = this.getAggressionLevels();
        if (aggressionLevels != null && (aggressionLevel = aggressionLevels.stream().findFirst()).isPresent()) {
            return (AggressionLevel)((Object)aggressionLevel.get());
        }
        return null;
    }

    default public AggressionLevel getLastAggressionLevel() {
        Optional aggressionLevel;
        Set<AggressionLevel> aggressionLevels = this.getAggressionLevels();
        if (aggressionLevels != null && (aggressionLevel = aggressionLevels.stream().reduce((first, second) -> second)).isPresent()) {
            return (AggressionLevel)((Object)aggressionLevel.get());
        }
        return null;
    }

    default public Item getTameItem() {
        return null;
    }

    default public Ingredient getFoodItems() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getTameItem()});
    }

    default public boolean doPlayJumpSound() {
        return true;
    }

    default public int getEntityGuiScaling() {
        return 60;
    }

    default public int getEntityGuiTop() {
        return 20;
    }

    default public SoundEvent getPetSound() {
        return SoundEvents.f_12625_;
    }

    default public SoundEvent getJumpSound() {
        return SoundEvents.f_12469_;
    }

    default public SoundEvent getWaitSound() {
        return null;
    }

    default public ParticleOptions getParticleType() {
        return null;
    }

    default public PlayerCompanionType getCompanionType() {
        return PlayerCompanionType.UNKNOWN;
    }

    default public ItemStack getCompanionTypeIcon() {
        return null;
    }
}

