/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerCompanionDamageManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;

    protected PlayerCompanionDamageManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if (Boolean.TRUE.equals(PlayerCompanionDamageManager.COMMON.friendlyFire.get())) {
            log.warn("{} friendly fire is enabled!", (Object)"\ud83d\udc7e Bo's Player Companions");
        } else {
            log.info("{} friendly fire is disabled.", (Object)"\ud83d\udc7e Bo's Player Companions");
        }
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        TamableAnimal tamableAnimal;
        if (Boolean.TRUE.equals(PlayerCompanionDamageManager.COMMON.friendlyFire.get())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof TamableAnimal && PlayerCompanionDamageManager.preventAttack(tamableAnimal = (TamableAnimal)livingEntity, event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        TamableAnimal tamableAnimal;
        if (Boolean.TRUE.equals(PlayerCompanionDamageManager.COMMON.friendlyFire.get())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof TamableAnimal && PlayerCompanionDamageManager.preventAttack(tamableAnimal = (TamableAnimal)livingEntity, event.getSource())) {
            event.setCanceled(true);
        }
    }

    public static boolean preventAttack(TamableAnimal attackedTamableAnimal, DamageSource source) {
        TamableAnimal tamableAnimal;
        if (attackedTamableAnimal == null || source == null) {
            return false;
        }
        LivingEntity owner = attackedTamableAnimal.m_269323_();
        if (owner == null) {
            return false;
        }
        UUID ownerUUID = owner.m_20148_();
        Entity damageSourceEntity = source.m_7639_();
        if (damageSourceEntity instanceof Player) {
            PlayerCompanionEntity playerCompanionEntity;
            Player player = (Player)damageSourceEntity;
            if (player.m_20148_().equals(ownerUUID)) {
                return !player.m_6047_();
            }
            if (attackedTamableAnimal instanceof PlayerCompanionEntity && ((playerCompanionEntity = (PlayerCompanionEntity)attackedTamableAnimal).getCompanionType() == PlayerCompanionType.COLLECTOR || playerCompanionEntity.getCompanionType() == PlayerCompanionType.FOLLOWER)) {
                return false;
            }
        }
        return damageSourceEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)damageSourceEntity).m_269323_() != null && ownerUUID.equals(tamableAnimal.m_269323_().m_20148_());
    }
}

