/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import com.mojang.datafixers.util.Pair;
import de.markusbordihn.playercompanions.block.LightBlock;
import de.markusbordihn.playercompanions.client.keymapping.ModKeyMapping;
import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.ActionType;
import de.markusbordihn.playercompanions.entity.PlayerCompanionCommand;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntityData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionMenu;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.TameablePlayerCompanion;
import de.markusbordihn.playercompanions.entity.ai.goal.FoodItemGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.TameItemGoal;
import de.markusbordihn.playercompanions.item.CapturedCompanion;
import de.markusbordihn.playercompanions.network.NetworkHandler;
import de.markusbordihn.playercompanions.skin.SkinType;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerCompanionEntity
extends PlayerCompanionEntityData
implements TameablePlayerCompanion {
    public static final MobCategory CATEGORY = MobCategory.CREATURE;
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final ResourceLocation RESPAWN_MESSAGE = new ResourceLocation("player_companions", "companion_respawn_message");
    private static final ResourceLocation LEVEL_UP_MESSAGE = new ResourceLocation("player_companions", "companion_level_up_message");
    private static final ResourceLocation WILL_RESPAWN_MESSAGE = new ResourceLocation("player_companions", "companion_will_respawn_message");
    private static final ResourceLocation WILL_NOT_RESPAWN_MESSAGE = new ResourceLocation("player_companions", "companion_will_not_respawn_message");
    private static final int BABY_GROW_TIME = 1728000;
    private static final int INACTIVE_TICK = 100;
    private static final int GLOW_TICK = 15;
    private static final int ANNOYING_COUNTER_TICK = 6000;
    private int ticker = 0;
    private int glowTicker = 0;
    private int annoyingCounterTicker = 0;
    private int annoyingCounter = 0;
    private boolean wasOnGround;

    public PlayerCompanionEntity(EntityType<? extends PlayerCompanionEntity> entityType, Level level, Map<PlayerCompanionVariant, Item> companionItemByVariant) {
        super(entityType, level, companionItemByVariant);
        this.setSyncReference(this);
        this.ticker = this.f_19796_.m_216339_(0, 50);
        this.glowTicker = this.f_19796_.m_216339_(0, 7);
        this.setDataSyncNeeded();
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if (Boolean.TRUE.equals(PlayerCompanionEntity.COMMON.respawnOnDeath.get())) {
            log.info("{} will be respawn on death with a {} secs delay.", (Object)"\ud83d\udc7e Bo's Player Companions", PlayerCompanionEntity.COMMON.respawnDelay.get());
        } else {
            log.warn("{} will NOT respawn on death!", (Object)"\ud83d\udc7e Bo's Player Companions");
        }
        if (Boolean.FALSE.equals(PlayerCompanionEntity.COMMON.friendlyFire.get())) {
            log.info("{} ignore entities from the same owner as attack target!", (Object)"\ud83d\udc7e Bo's Player Companions");
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void addParticle(ParticleOptions particleOptions) {
        for (int i = 0; i < 4; ++i) {
            float randomCircleDistance = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
            float randomOffset = this.f_19796_.m_188501_() * 0.5f + 0.5f;
            float randomOffsetX = Mth.m_14031_((float)randomCircleDistance) * 0.5f * randomOffset;
            float randomOffsetZ = Mth.m_14089_((float)randomCircleDistance) * 0.5f * randomOffset;
            this.m_9236_().m_7106_(particleOptions, this.m_20185_() + (double)randomOffsetX, this.m_20186_() + 0.5, this.m_20189_() + (double)randomOffsetZ, 0.0, 0.0, 0.0);
        }
    }

    protected void playSound(Player player, SoundEvent sound) {
        this.playSound(player, sound, this.m_6121_(), this.getSoundPitch());
    }

    protected void playSound(Player player, SoundEvent sound, float volume, float pitch) {
        Level level = player.m_9236_();
        if (level.f_46443_ && sound != null && sound.m_11660_() != null && volume > 0.0f && pitch >= 0.0f) {
            player.m_5496_(sound, volume, pitch);
        }
    }

    public void follow() {
        this.setActionType(ActionType.FOLLOW);
        this.m_21839_(false);
        this.f_21344_.m_26569_();
    }

    protected void sit() {
        this.setActionType(ActionType.SIT);
        this.m_21839_(true);
        this.f_21344_.m_26573_();
        super.m_6710_(null);
    }

    protected void pet() {
        if (this.m_21223_() < this.m_21233_()) {
            this.m_21153_((float)((double)this.m_21223_() + 0.1));
        }
    }

    public boolean eat(ItemStack itemStack, Player player) {
        Item item;
        FoodProperties foodProperties;
        if (!this.canEat(itemStack)) {
            return false;
        }
        this.m_146852_(GameEvent.f_157806_, (Entity)this);
        SoundEvent eatingSound = this.m_7866_(itemStack);
        if (eatingSound != null) {
            this.m_5496_(eatingSound, this.m_6121_(), this.getSoundPitch());
        }
        this.m_5634_((foodProperties = (item = itemStack.m_41720_()).getFoodProperties(itemStack, (LivingEntity)this)) != null ? (float)foodProperties.m_38744_() : 0.5f);
        if (foodProperties != null) {
            for (Pair pair : foodProperties.m_38749_()) {
                Level level = this.m_9236_();
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                this.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if (player != null && !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_146850_(GameEvent.f_157806_);
        return true;
    }

    public boolean canEat() {
        return this.m_21223_() < this.m_21233_();
    }

    public boolean canEat(ItemStack itemStack) {
        return this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_();
    }

    public void handleCommand(PlayerCompanionCommand command) {
        switch (command) {
            case SIT: {
                this.sit();
                break;
            }
            case FOLLOW: {
                this.follow();
                break;
            }
            case SIT_FOLLOW_TOGGLE: {
                if (this.m_21827_()) {
                    this.follow();
                    break;
                }
                this.sit();
                break;
            }
            case AGGRESSION_LEVEL_DEFAULT: {
                this.setAggressionLevel(this.getDefaultAggressionLevel());
                break;
            }
            case AGGRESSION_LEVEL_NEXT: {
                this.setAggressionLevel(this.getNextAggressionLevel());
                break;
            }
            case AGGRESSION_LEVEL_PREVIOUS: {
                this.setAggressionLevel(this.getPreviousAggressionLevel());
                break;
            }
            case AGGRESSION_LEVEL_TOGGLE: {
                this.toggleAggressionLevel();
                break;
            }
            case OPEN_MENU: {
                PlayerCompanionMenu.openMenu(this);
                break;
            }
            case PET: {
                this.pet();
            }
        }
    }

    public void finalizeSpawn() {
        ItemStack offHandItemStack;
        ItemStack mainHandItemStack;
        int respawnTimer;
        if (!this.m_8077_()) {
            this.m_6593_((Component)Component.m_237113_((String)this.getRandomName()));
        }
        if (this.isCharging()) {
            this.setCharging(false);
        }
        if ((respawnTimer = this.getRespawnTimer()) > 0 && (long)respawnTimer < Instant.now().getEpochSecond()) {
            this.stopRespawnTimer();
        }
        if ((mainHandItemStack = this.m_6844_(EquipmentSlot.MAINHAND)) != null) {
            this.onMainHandItemSlotChange(mainHandItemStack);
        }
        if ((offHandItemStack = this.m_6844_(EquipmentSlot.OFFHAND)) != null) {
            this.onOffHandItemSlotChange(offHandItemStack);
        }
        if (this.getVariant() == PlayerCompanionVariant.NONE) {
            this.setVariant(PlayerCompanionVariant.DEFAULT);
        }
    }

    public void sendOwnerMessage(Component component) {
        LivingEntity owner = this.m_269323_();
        if (component != null && owner != null) {
            owner.m_213846_(component);
        }
    }

    public boolean canRespawnOnDeath() {
        return Boolean.TRUE.equals(PlayerCompanionEntity.COMMON.respawnOnDeath.get());
    }

    @Override
    public void onLevelUp(int level) {
        super.onLevelUp(level);
        if (level > 1) {
            this.addParticle((ParticleOptions)ParticleTypes.f_123809_);
            this.sendOwnerMessage((Component)Component.m_237110_((String)Util.m_137492_((String)"entity", (ResourceLocation)LEVEL_UP_MESSAGE), (Object[])new Object[]{this.m_7770_(), level}));
        }
    }

    public int m_8100_() {
        return 400;
    }

    public float m_6121_() {
        return 1.0f;
    }

    @Override
    public void setRespawnTimer(int timer) {
        super.setRespawnTimer(timer);
        this.setDataSyncNeeded();
    }

    @Override
    public void stopRespawnTimer() {
        super.stopRespawnTimer();
        this.sendOwnerMessage((Component)Component.m_237110_((String)Util.m_137492_((String)"entity", (ResourceLocation)RESPAWN_MESSAGE), (Object[])new Object[]{this.m_7770_()}));
        this.setDataSyncNeeded();
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        TamableAnimal tamableAnimal;
        if (this.m_5448_() == livingEntity) {
            return;
        }
        if (livingEntity == null || !livingEntity.m_6084_()) {
            super.m_6710_(null);
            this.setDataSyncNeeded();
            return;
        }
        if (!((Boolean)PlayerCompanionEntity.COMMON.friendlyFire.get()).booleanValue() && livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).m_269323_() == this.m_269323_()) {
            return;
        }
        super.m_6710_(livingEntity);
        this.setDataSyncNeeded();
    }

    @Override
    public boolean canTamePlayerCompanion(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        return this.isTamable() && this.getTameItem() != null && itemStack.m_150930_(this.getTameItem()) && player.m_150109_().m_7013_(1, itemStack);
    }

    @Override
    public InteractionResult tamePlayerCompanion(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (itemStack != null && !player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(4) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.follow();
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return InteractionResult.CONSUME;
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        log.info("Player {} tamed player companion {} ...", (Object)player, (Object)this);
        if (player instanceof ServerPlayer) {
            this.registerData();
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.isTamable() && this.getTameItem() != null) {
            this.f_21345_.m_25352_(3, (Goal)new TameItemGoal(this, 0.8));
            this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        }
        if (this.getFoodItems() != null && !this.getFoodItems().m_43947_()) {
            this.f_21345_.m_25352_(3, (Goal)new FoodItemGoal(this, 1.0));
        }
    }

    @Override
    public PlayerCompanionEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(player.m_7655_());
        boolean isOwner = this.m_21824_() && this.m_21830_((LivingEntity)player);
        Level level = this.m_9236_();
        if (level.f_46443_) {
            if (isOwner) {
                CapturedCompanion capturedCompanion;
                Item item;
                boolean commandKeyPressed = ModKeyMapping.COMMAND_KEY.m_90857_();
                if (commandKeyPressed && (itemStack.m_41619_() || this.isWeapon(itemStack))) {
                    NetworkHandler.commandPlayerCompanion(this.m_20149_(), PlayerCompanionCommand.SIT_FOLLOW_TOGGLE);
                    return InteractionResult.SUCCESS;
                }
                boolean aggressionKeyPressed = ModKeyMapping.AGGRESSION_KEY.m_90857_();
                if (aggressionKeyPressed && (itemStack.m_41619_() || this.isWeapon(itemStack))) {
                    NetworkHandler.commandPlayerCompanion(this.m_20149_(), PlayerCompanionCommand.AGGRESSION_LEVEL_TOGGLE);
                    return InteractionResult.SUCCESS;
                }
                if (player.m_6047_() && itemStack.m_41619_()) {
                    this.addParticle((ParticleOptions)ParticleTypes.f_123750_);
                    if (this.getPetSound() != null) {
                        this.playSound(player, this.getPetSound());
                    }
                    NetworkHandler.commandPlayerCompanion(this.m_20149_(), PlayerCompanionCommand.PET);
                    return InteractionResult.SUCCESS;
                }
                if (itemStack != null && !itemStack.m_41619_() && (item = itemStack.m_41720_()) instanceof CapturedCompanion && !(capturedCompanion = (CapturedCompanion)item).hasCompanion(itemStack)) {
                    return InteractionResult.FAIL;
                }
                if (!this.m_6898_(itemStack)) {
                    NetworkHandler.commandPlayerCompanion(this.m_20149_(), PlayerCompanionCommand.OPEN_MENU);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (this.getTameItem() != null && itemStack.m_150930_(this.getTameItem()) && !this.m_21824_()) {
                    return InteractionResult.CONSUME;
                }
                if (!this.m_21824_() && !this.m_6898_(itemStack) && this.getTameItem() != null) {
                    if (this.annoyingCounter < 10) {
                        player.m_213846_((Component)Component.m_237110_((String)"text.player_companions.untamed_companion.interaction", (Object[])new Object[]{this.m_7770_(), this.getTameItem()}));
                        ++this.annoyingCounter;
                    } else {
                        player.m_213846_((Component)Component.m_237110_((String)"text.player_companions.untamed_companion.interaction.annoying", (Object[])new Object[]{this.m_7770_()}).m_130940_(ChatFormatting.RED));
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (this.m_6898_(itemStack)) {
            if (this.canEat(itemStack)) {
                if (this.eat(itemStack, player)) {
                    this.addParticle((ParticleOptions)ParticleTypes.f_123750_);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else {
                log.debug("{} is fully staffed ...", (Object)this);
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (sound != null && sound.m_11660_() != null && volume > 0.0f && pitch >= 0.0f) {
            super.m_5496_(sound, volume, pitch);
        }
    }

    public boolean m_6898_(ItemStack itemStack) {
        if (this.getFoodItems() != null) {
            return this.getFoodItems().test(itemStack);
        }
        if (!itemStack.m_41614_()) {
            return false;
        }
        return super.m_6898_(itemStack);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setDataSyncNeeded();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        spawnGroupData = super.m_6518_(serverLevelAccessor, difficulty, mobSpawnType, spawnGroupData, compoundTag);
        if (SkinType.DEFAULT.equals((Object)this.getSkinType()) && this.getVariant() == PlayerCompanionVariant.NONE) {
            this.setVariant(this.getRandomVariant());
        }
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_146762_(-1728000);
        }
        this.finalizeSpawn();
        return spawnGroupData;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isActive()) {
            if (this.ticker++ >= 100) {
                this.ticker = 0;
            } else {
                return;
            }
        }
        Level level = this.m_9236_();
        if (level.f_46443_ && this.annoyingCounter > 0 && this.annoyingCounterTicker++ >= 6000) {
            this.annoyingCounter = 0;
            this.annoyingCounterTicker = 0;
        }
        if (!level.f_46443_ && this.shouldGlowInTheDark() && this.glowTicker++ >= 15) {
            BlockPos lightBlockPos = this.m_20097_();
            if (level.m_46462_() || level.m_46471_() || level.m_46470_() || !level.m_45527_(lightBlockPos)) {
                LightBlock.place(level, lightBlockPos);
            }
            this.glowTicker = 0;
        }
        if (this.m_20096_() && !this.wasOnGround) {
            if (this.getParticleType() != null) {
                for (int j = 0; j < 4; ++j) {
                    float f = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f1 = this.f_19796_.m_188501_() * 0.5f + 0.5f;
                    float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
                    float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
                    level.m_7106_(this.getParticleType(), this.m_20185_() + (double)f2, this.m_20186_(), this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
            if (this.doPlayJumpSound() && this.getJumpSound() != null) {
                this.m_5496_(this.getJumpSound(), this.m_6121_(), this.getSoundPitch());
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (this.canRespawnOnDeath()) {
            this.m_20095_();
            this.m_21455_(true, true);
            this.m_21219_();
            this.m_20242_(false);
        }
        Level level = this.m_9236_();
        if (this.m_21824_() && !level.m_5776_()) {
            if (this.canRespawnOnDeath()) {
                this.decreaseExperienceLevel();
                if ((Integer)PlayerCompanionEntity.COMMON.respawnDelay.get() > 1) {
                    this.setRespawnTimer((int)Instant.now().getEpochSecond() + (Integer)PlayerCompanionEntity.COMMON.respawnDelay.get());
                }
                this.sendOwnerMessage((Component)Component.m_237110_((String)Util.m_137492_((String)"entity", (ResourceLocation)WILL_RESPAWN_MESSAGE), (Object[])new Object[]{this.m_7770_(), PlayerCompanionEntity.COMMON.respawnDelay.get()}));
            } else {
                this.sendOwnerMessage((Component)Component.m_237110_((String)Util.m_137492_((String)"entity", (ResourceLocation)WILL_NOT_RESPAWN_MESSAGE), (Object[])new Object[]{this.m_7770_()}));
                this.setActive(false);
                PlayerCompanionsServerData.get().unregisterCompanion(this);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void m_21839_(boolean sit) {
        if (this.m_21827_() != sit) {
            super.m_21839_(sit);
            this.setDataSyncNeeded();
        }
    }

    public String toString() {
        Entity.RemovalReason removalReason = this.m_146911_();
        String level = this.m_9236_() == null ? "~NULL~" : this.m_9236_().toString();
        UUID ownerUUID = this.m_21805_();
        String owner = ownerUUID == null ? "~NULL~" : ownerUUID.toString();
        Boolean tamed = this.m_21824_();
        int id = this.m_19879_();
        return removalReason != null ? String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, tamed=%s, owner='%s', removed=%s]", this.getClass().getSimpleName(), this.m_7755_().getString(), id, level, this.m_20185_(), this.m_20186_(), this.m_20189_(), tamed, owner, removalReason) : String.format(Locale.ROOT, "%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f, tamed=%s, owner='%s']", this.getClass().getSimpleName(), this.m_7755_().getString(), id, level, this.m_20185_(), this.m_20186_(), this.m_20189_(), tamed, owner);
    }
}

