/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsDataSync;
import de.markusbordihn.playercompanions.entity.ActionType;
import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.PlayerCompanionAttributes;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionExperience;
import de.markusbordihn.playercompanions.entity.PlayerCompanionNames;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.skin.SkinModel;
import de.markusbordihn.playercompanions.skin.SkinType;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerCompanionEntityData
extends TamableAnimal
implements PlayerCompanionsDataSync,
PlayerCompanionExperience,
PlayerCompanionAttributes {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    protected static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final int RIDE_COOLDOWN = 600;
    protected static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_EXPERIENCE = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_EXPERIENCE_LEVEL = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_RESPAWN_TIMER = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_SKIN_URL = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SKIN_UUID = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> DATA_SKIN_TYPE = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_VARIANT = SynchedEntityData.m_135353_(PlayerCompanionEntityData.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String DATA_ACTIVE_TAG = "Active";
    private static final String DATA_EXPERIENCE_LEVEL_TAG = "CompanionExperienceLevel";
    private static final String DATA_EXPERIENCE_TAG = "CompanionExperience";
    private static final String DATA_RESPAWN_TIMER_TAG = "CompanionRespawnTicker";
    private static final String DATA_SKIN_URL_TAG = "SkinURL";
    private static final String DATA_SKIN_UUID_TAG = "SkinUUID";
    private static final String DATA_SKIN_TYPE_TAG = "SkinType";
    private static final String DATA_VARIANT_TAG = "Variant";
    private static final String ATTRIBUTE_MAX_HEALTH = "Player Companions Max Health";
    private static final String ATTRIBUTE_ATTACK_DAMAGE = "Player Companions Attack Damage";
    private static final int JUMP_MOVE_DELAY = 10;
    private static final int DATA_SYNC_TICK = 10;
    private final Map<PlayerCompanionVariant, Item> companionItemByVariant;
    protected UUID persistentAngerTarget;
    protected int rideCooldownCounter;
    private int explosionPower = 0;
    private ActionType actionType = ActionType.UNKNOWN;
    private AggressionLevel aggressionLevel = AggressionLevel.UNKNOWN;
    private BlockPos orderedToPosition = null;
    private String dimensionName = "";
    private boolean isDataSyncNeeded = false;
    private boolean sitOnShoulder = false;
    private boolean shouldAttack = false;
    private boolean shouldGlowInTheDark = false;
    private boolean enableCustomTextureSkin = false;
    private PlayerCompanionEntity playerCompanionEntity;
    private int dataSyncTicker = 0;

    protected PlayerCompanionEntityData(EntityType<? extends TamableAnimal> entityType, Level level, Map<PlayerCompanionVariant, Item> companionItemByVariant) {
        super(entityType, level);
        this.dimensionName = level.m_46472_().m_135782_().toString();
        this.companionItemByVariant = companionItemByVariant;
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if ((Integer)PlayerCompanionEntityData.COMMON.maxHealth.get() > 0) {
            log.info("The max base health for player companions is set to {}.", PlayerCompanionEntityData.COMMON.maxHealth.get());
        } else {
            log.warn("The max base health for player companions will not be adjusted!");
        }
        if ((Integer)PlayerCompanionEntityData.COMMON.maxAttackDamage.get() > 0) {
            log.info("The max base attack damage for player companions is set to {}.", PlayerCompanionEntityData.COMMON.maxAttackDamage.get());
        } else {
            log.warn("The max base attack damage for player companions will not be adjusted!");
        }
    }

    public void enableCustomTextureSkin(boolean enable) {
        this.enableCustomTextureSkin = enable;
    }

    public boolean enableCustomTextureSkin() {
        return this.enableCustomTextureSkin;
    }

    @Override
    public PlayerCompanionEntity getSyncReference() {
        return this.playerCompanionEntity;
    }

    public void setSyncReference(PlayerCompanionEntity playerCompanionEntity) {
        this.playerCompanionEntity = playerCompanionEntity;
    }

    public boolean isTamable() {
        return !this.m_21824_();
    }

    public Player getNearestPlayer(TargetingConditions targetingConditions) {
        return this.m_9236_().m_45946_(targetingConditions, (LivingEntity)this);
    }

    public Item getCompanionItem() {
        return this.companionItemByVariant.getOrDefault((Object)this.getVariant(), this.companionItemByVariant.get((Object)PlayerCompanionVariant.DEFAULT));
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)charging);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)active);
    }

    public void setDataSyncNeeded() {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.hasOwner()) {
            this.isDataSyncNeeded = true;
        }
    }

    @Override
    public boolean getDataSyncNeeded() {
        return this.isDataSyncNeeded;
    }

    @Override
    public void setDataSyncNeeded(boolean dirty) {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            this.isDataSyncNeeded = dirty;
        }
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(int explosionPower) {
        this.explosionPower = explosionPower;
    }

    public String getSkinURL() {
        return (String)this.f_19804_.m_135370_(DATA_SKIN_URL);
    }

    public void setSkinURL(String skinURL) {
        this.f_19804_.m_135381_(DATA_SKIN_URL, (Object)(skinURL != null ? skinURL : ""));
    }

    public Optional<UUID> getSkinUUID() {
        return (Optional)this.f_19804_.m_135370_(DATA_SKIN_UUID);
    }

    public void setSkinUUID(UUID uuid) {
        this.f_19804_.m_135381_(DATA_SKIN_UUID, Optional.of(uuid));
    }

    public void setSkinUUID(Optional<UUID> uuid) {
        this.f_19804_.m_135381_(DATA_SKIN_UUID, uuid);
    }

    public SkinType getSkinType() {
        return this.getSkinType((String)this.f_19804_.m_135370_(DATA_SKIN_TYPE));
    }

    public void setSkinType(SkinType skinType) {
        this.f_19804_.m_135381_(DATA_SKIN_TYPE, (Object)(skinType != null ? skinType.name() : ""));
    }

    public void setSkinType(String name) {
        SkinType skinType = this.getSkinType(name);
        if (skinType != null) {
            this.setSkinType(skinType);
        } else {
            log.error("Unknown skin type {} for {}", (Object)name, (Object)this);
        }
    }

    public SkinType getSkinType(String name) {
        return SkinType.get(name);
    }

    public SkinModel getSkinModel() {
        return SkinModel.CUSTOM;
    }

    public PlayerCompanionVariant getVariant() {
        return PlayerCompanionVariant.getOrDefault((String)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    public void setVariant(PlayerCompanionVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.name());
    }

    public PlayerCompanionVariant getRandomVariant() {
        return PlayerCompanionVariant.DEFAULT;
    }

    public void setGlowInTheDark(boolean glowInTheDark) {
        this.shouldGlowInTheDark = glowInTheDark;
    }

    public boolean shouldGlowInTheDark() {
        return this.shouldGlowInTheDark;
    }

    @Override
    public int getExperience() {
        return (Integer)this.f_19804_.m_135370_(DATA_EXPERIENCE);
    }

    @Override
    public int setExperience(int experience) {
        if (experience >= 1) {
            this.f_19804_.m_135381_(DATA_EXPERIENCE, (Object)experience);
            if (this.isMaxExperienceLevel()) {
                return -1;
            }
            if (this.getExperienceForNextLevel() <= this.getExperience()) {
                return this.increaseExperienceLevel(1);
            }
            if (this.getExperienceForLevel() >= this.getExperience()) {
                this.decreaseExperienceLevel(1);
            }
        }
        return -1;
    }

    @Override
    public int getExperienceLevel() {
        return (Integer)this.f_19804_.m_135370_(DATA_EXPERIENCE_LEVEL);
    }

    @Override
    public int setExperienceLevel(int level) {
        if (level >= this.getMinExperienceLevel() && level != this.getExperienceLevel()) {
            this.f_19804_.m_135381_(DATA_EXPERIENCE_LEVEL, (Object)level);
            this.syncData();
        }
        return this.getExperienceLevel();
    }

    @Override
    public void onLevelUp(int level) {
        log.debug("Level up for {} to {} ...", (Object)this, (Object)level);
        this.adjustMaxHealthPerLevel(level);
        this.adjustAttackDamagePerLevel(level);
        this.syncData();
    }

    @Override
    public void onLevelDown(int level) {
        log.debug("Level down for {} to {} ...", (Object)this, (Object)level);
        this.adjustMaxHealthPerLevel(level);
        this.adjustAttackDamagePerLevel(level);
        this.syncData();
    }

    @Override
    public void onExperienceChange(int experience) {
        this.setDataSyncNeeded();
    }

    public int getRespawnTimer() {
        return (Integer)this.f_19804_.m_135370_(DATA_RESPAWN_TIMER);
    }

    public void setRespawnTimer(int timer) {
        if ((long)timer > Instant.now().getEpochSecond()) {
            this.setActive(false);
        }
        this.f_19804_.m_135381_(DATA_RESPAWN_TIMER, (Object)timer);
    }

    public void stopRespawnTimer() {
        this.setActive(true);
        this.setRespawnTimer(0);
    }

    public String getRandomName() {
        return PlayerCompanionNames.getRandomCompanionName();
    }

    public int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    public int getWaitDelay() {
        return this.f_19796_.m_188503_(200) + 10;
    }

    public int getJumpMoveDelay() {
        return 10;
    }

    public float getSoundPitch() {
        float randomSoundPitch = ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 1.4f;
        return Math.max(randomSoundPitch, 0.0f);
    }

    public boolean hasRideCooldown() {
        return this.rideCooldownCounter > 600;
    }

    public int getRideCooldownCounter() {
        return this.rideCooldownCounter;
    }

    public void setRideCooldownCounter(int cooldown) {
        this.rideCooldownCounter = cooldown;
    }

    public void increaseRideCooldownCounter() {
        ++this.rideCooldownCounter;
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        this.f_21342_.m_6849_(x, y, z, speed);
    }

    public boolean setEntityOnShoulder(ServerPlayer serverPlayer) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("id", this.m_20078_());
        this.m_20240_(compoundTag);
        if (serverPlayer.m_36360_(compoundTag)) {
            this.m_146870_();
            this.setSitOnShoulder(true);
            return true;
        }
        this.setSitOnShoulder(false);
        return false;
    }

    public boolean canSitOnShoulder() {
        return false;
    }

    public boolean isSitOnShoulder() {
        return this.sitOnShoulder;
    }

    public void setSitOnShoulder(boolean sitOnShoulder) {
        if (this.sitOnShoulder == sitOnShoulder) {
            return;
        }
        this.sitOnShoulder = sitOnShoulder;
        this.syncData();
    }

    public boolean hasOwner() {
        return this.m_21805_() != null;
    }

    public boolean hasOwnerAndIsAlive() {
        return this.m_21805_() != null && this.m_6084_();
    }

    public boolean isOrderedToPosition() {
        return this.orderedToPosition != null;
    }

    public BlockPos getOrderedToPosition() {
        return this.orderedToPosition;
    }

    public void setOrderedToPosition(BlockPos blockPos) {
        if (this.orderedToPosition == blockPos) {
            return;
        }
        this.orderedToPosition = blockPos;
        this.setDataSyncNeeded();
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        if (this.actionType == actionType) {
            return;
        }
        this.actionType = actionType;
        this.setDataSyncNeeded();
    }

    public AggressionLevel getAggressionLevel() {
        return this.aggressionLevel;
    }

    public void setAggressionLevel(AggressionLevel aggressionLevel) {
        if (this.aggressionLevel == aggressionLevel) {
            return;
        }
        this.aggressionLevel = aggressionLevel;
        this.shouldAttack = this.aggressionLevel == AggressionLevel.NEUTRAL || this.aggressionLevel == AggressionLevel.AGGRESSIVE || this.aggressionLevel == AggressionLevel.AGGRESSIVE_ANIMALS || this.aggressionLevel == AggressionLevel.AGGRESSIVE_MONSTER || this.aggressionLevel == AggressionLevel.AGGRESSIVE_PLAYERS || this.aggressionLevel == AggressionLevel.AGGRESSIVE_ALL;
        this.setDataSyncNeeded();
    }

    public AggressionLevel getNextAggressionLevel() {
        return this.getNextAggressionLevel(this.aggressionLevel);
    }

    public AggressionLevel getPreviousAggressionLevel() {
        return this.getPreviousAggressionLevel(this.aggressionLevel);
    }

    public void toggleAggressionLevel() {
        if (this.aggressionLevel == this.getLastAggressionLevel()) {
            this.setAggressionLevel(this.getFirstAggressionLevel());
        } else {
            AggressionLevel nextAggressionLevel = this.getNextAggressionLevel();
            if (nextAggressionLevel != this.aggressionLevel) {
                this.setAggressionLevel(nextAggressionLevel);
            }
        }
    }

    public boolean shouldAttack() {
        return this.shouldAttack;
    }

    public boolean canAttack() {
        Player player;
        LivingEntity livingEntity = this.playerCompanionEntity.m_5448_();
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_5833_() || player.m_7500_())) {
            return false;
        }
        return livingEntity != null && livingEntity.m_6084_() && this.m_6084_();
    }

    public BlockPos ownerBlockPosition() {
        LivingEntity owner;
        if (this.hasOwner() && (owner = this.m_269323_()) != null && owner.m_6084_() && owner.isAddedToWorld()) {
            return owner.m_20183_();
        }
        return this.m_20183_();
    }

    public boolean isWeapon(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof SwordItem || item instanceof CrossbowItem || item instanceof TridentItem || item instanceof BowItem || item instanceof AxeItem;
    }

    public PlayerCompanionData getData() {
        return this.getData(this.m_20148_());
    }

    public void setArmorItem(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public void setHandItem(int slot, ItemStack itemStack) {
        if (slot == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
        } else if (slot == 1) {
            this.m_8061_(EquipmentSlot.OFFHAND, itemStack);
        }
    }

    public void adjustMaxHealthPerLevel(int level) {
        int healthAdjustment = this.getHealthAdjustmentFromExperienceLevel(level, (Integer)PlayerCompanionEntityData.COMMON.maxHealth.get(), (int)this.m_21051_(Attributes.f_22276_).m_22115_());
        this.increaseMaxHealth(healthAdjustment);
    }

    public void increaseMaxHealth(int health) {
        if (health > 0) {
            Set attributeModifiers = this.m_21051_(Attributes.f_22276_).m_22122_();
            if (!attributeModifiers.isEmpty()) {
                for (AttributeModifier attributeModifier : attributeModifiers) {
                    if (attributeModifier == null || !attributeModifier.m_22214_().equals(ATTRIBUTE_MAX_HEALTH)) continue;
                    this.m_21051_(Attributes.f_22276_).m_22130_(attributeModifier);
                }
            }
            AttributeModifier increaseHealthModifier = new AttributeModifier(ATTRIBUTE_MAX_HEALTH, (double)health, AttributeModifier.Operation.ADDITION);
            this.m_21051_(Attributes.f_22276_).m_22118_(increaseHealthModifier);
            if (this.m_6084_()) {
                this.m_5634_(this.m_21233_());
            }
        }
    }

    public void adjustAttackDamagePerLevel(int level) {
        int attackDamageAdjustment = this.getAttackDamageAdjustmentFromExperienceLevel(level, (Integer)PlayerCompanionEntityData.COMMON.maxAttackDamage.get(), (int)this.m_21051_(Attributes.f_22281_).m_22115_());
        this.increaseAttackDamage(attackDamageAdjustment);
    }

    public void increaseAttackDamage(int attackDamage) {
        if (attackDamage > 0) {
            Set attributeModifiers = this.m_21051_(Attributes.f_22281_).m_22122_();
            if (!attributeModifiers.isEmpty()) {
                for (AttributeModifier attributeModifier : attributeModifiers) {
                    if (attributeModifier == null || !attributeModifier.m_22214_().equals(ATTRIBUTE_ATTACK_DAMAGE)) continue;
                    this.m_21051_(Attributes.f_22281_).m_22130_(attributeModifier);
                }
            }
            AttributeModifier increaseAttackDamageModifier = new AttributeModifier(ATTRIBUTE_ATTACK_DAMAGE, (double)attackDamage, AttributeModifier.Operation.ADDITION);
            this.m_21051_(Attributes.f_22281_).m_22118_(increaseAttackDamageModifier);
        }
    }

    public int getAttackDamage() {
        Collection attributeModifierCollection;
        double baseAttackDamage = this.m_21051_(Attributes.f_22281_).m_22135_();
        ItemStack mainHandItem = this.m_21205_();
        if (mainHandItem != null && !mainHandItem.m_41619_() && (attributeModifierCollection = mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) != null && !attributeModifierCollection.isEmpty()) {
            for (AttributeModifier attributeModifier : attributeModifierCollection) {
                if (attributeModifier == null) continue;
                baseAttackDamage += attributeModifier.m_22218_();
            }
        }
        return (int)baseAttackDamage;
    }

    public void onMainHandItemSlotChange(ItemStack itemStack) {
    }

    public void onOffHandItemSlotChange(ItemStack itemStack) {
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setDataSyncNeeded();
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        super.m_8061_(equipmentSlot, itemStack);
        PlayerCompanionData data = this.getData();
        if (data != null) {
            if (equipmentSlot.m_20743_() == EquipmentSlot.Type.HAND) {
                data.setHandItem(equipmentSlot.m_20749_(), itemStack);
                if (equipmentSlot == EquipmentSlot.MAINHAND) {
                    this.onMainHandItemSlotChange(itemStack);
                } else if (equipmentSlot == EquipmentSlot.OFFHAND) {
                    this.onOffHandItemSlotChange(itemStack);
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                data.setArmorItem(equipmentSlot.m_20749_(), itemStack);
            }
        }
        this.setDataSyncNeeded();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE, (Object)true);
        this.f_19804_.m_135372_(DATA_EXPERIENCE, (Object)1);
        this.f_19804_.m_135372_(DATA_EXPERIENCE_LEVEL, (Object)1);
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(DATA_RESPAWN_TIMER, (Object)0);
        this.f_19804_.m_135372_(DATA_SKIN_URL, (Object)"");
        this.f_19804_.m_135372_(DATA_SKIN_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SKIN_TYPE, (Object)SkinType.DEFAULT.name());
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)PlayerCompanionVariant.NONE.name());
    }

    public void m_7380_(CompoundTag compoundTag) {
        Optional<UUID> skinUUID;
        super.m_7380_(compoundTag);
        compoundTag.m_128379_(DATA_ACTIVE_TAG, this.isActive());
        compoundTag.m_128405_(DATA_EXPERIENCE_LEVEL_TAG, this.getExperienceLevel());
        compoundTag.m_128405_(DATA_EXPERIENCE_TAG, this.getExperience());
        compoundTag.m_128405_(DATA_RESPAWN_TIMER_TAG, this.getRespawnTimer());
        if (this.getSkinURL() != null) {
            compoundTag.m_128359_(DATA_SKIN_URL_TAG, this.getSkinURL());
        }
        if ((skinUUID = this.getSkinUUID()).isPresent()) {
            compoundTag.m_128362_(DATA_SKIN_UUID_TAG, skinUUID.get());
        }
        if (this.getSkinType() != null) {
            compoundTag.m_128359_(DATA_SKIN_TYPE_TAG, this.getSkinType().name());
        }
        compoundTag.m_128359_(DATA_VARIANT_TAG, this.getVariant().name());
    }

    public void m_7378_(CompoundTag compoundTag) {
        String skinType;
        UUID skinUUID;
        String url;
        ItemStack itemStack;
        super.m_7378_(compoundTag);
        this.setActive(compoundTag.m_128471_(DATA_ACTIVE_TAG));
        this.setExperienceLevel(Math.max(compoundTag.m_128451_(DATA_EXPERIENCE_LEVEL_TAG), 1));
        this.setExperience(Math.max(compoundTag.m_128451_(DATA_EXPERIENCE_TAG), 1));
        int experienceLevel = this.getExperienceLevel();
        if (experienceLevel > this.getMinExperienceLevel()) {
            this.adjustMaxHealthPerLevel(experienceLevel);
            this.adjustAttackDamagePerLevel(experienceLevel);
        }
        if (compoundTag.m_128441_(DATA_RESPAWN_TIMER_TAG)) {
            this.setRespawnTimer(compoundTag.m_128451_(DATA_RESPAWN_TIMER_TAG));
        }
        if ((itemStack = this.m_6844_(EquipmentSlot.MAINHAND)) != null && !itemStack.m_41619_() && itemStack.m_150930_(Items.f_42000_) && !this.shouldGlowInTheDark) {
            this.shouldGlowInTheDark = true;
        }
        if (compoundTag.m_128441_(DATA_SKIN_URL_TAG) && (url = compoundTag.m_128461_(DATA_SKIN_URL_TAG)) != null && !url.isEmpty()) {
            this.setSkinURL(url);
        }
        if (compoundTag.m_128441_(DATA_SKIN_UUID_TAG) && (skinUUID = compoundTag.m_128342_(DATA_SKIN_UUID_TAG)) != null) {
            this.setSkinUUID(skinUUID);
        }
        if (compoundTag.m_128441_(DATA_SKIN_TYPE_TAG) && (skinType = compoundTag.m_128461_(DATA_SKIN_TYPE_TAG)) != null && !skinType.isEmpty()) {
            this.setSkinType(this.getSkinType(skinType));
        }
        this.setVariant(PlayerCompanionVariant.getOrDefault(compoundTag.m_128461_(DATA_VARIANT_TAG)));
    }

    public PlayerCompanionEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.dataSyncTicker++ >= 10 && this.syncDataIfNeeded()) {
            this.dataSyncTicker = 0;
        }
    }
}

