/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.data.Experience;

public interface PlayerCompanionExperience {
    public int getExperience();

    public int setExperience(int var1);

    public int getExperienceLevel();

    public int setExperienceLevel(int var1);

    public void onLevelUp(int var1);

    public void onLevelDown(int var1);

    public void onExperienceChange(int var1);

    default public boolean isMaxExperienceLevel() {
        return this.getExperienceLevel() >= this.getMaxExperienceLevel();
    }

    default public boolean isMinExperienceLevel() {
        return this.getExperienceLevel() == this.getMinExperienceLevel();
    }

    default public int getMaxExperienceLevel() {
        return 60;
    }

    default public int getMinExperienceLevel() {
        return 1;
    }

    default public int increaseExperienceLevel(int level) {
        return this.setExperienceLevel(this.getExperienceLevel() + level);
    }

    default public void decreaseExperienceLevel(int level) {
        this.setExperienceLevel(this.getExperienceLevel() - level);
    }

    default public void decreaseExperienceAndExperienceLevel() {
        this.decreaseExperience(Experience.getExperienceDifferenceForLevel(this.getExperienceLevel()));
    }

    default public void increaseExperience(int experience) {
        int levelUp = this.setExperience(this.getExperience() + experience);
        if (levelUp > this.getMinExperienceLevel()) {
            this.onLevelUp(levelUp);
        }
        this.onExperienceChange(this.getExperience());
    }

    default public void decreaseExperience(int experience) {
        this.setExperience(this.getExperience() - experience);
    }

    default public void decreaseExperienceLevel() {
        this.decreaseExperienceAndExperienceLevel();
        this.onLevelDown(this.getExperienceLevel());
    }

    default public int getExperienceForNextLevel() {
        return Experience.getExperienceForNextLevel(this.getExperienceLevel());
    }

    default public int getExperienceForLevel() {
        return Experience.getExperienceForLevel(this.getExperienceLevel());
    }

    default public int getHealthAdjustmentFromExperienceLevel(int level, int maxHealth, int baseHealth) {
        if (level == 1 || maxHealth == 0 || baseHealth >= maxHealth) {
            return 0;
        }
        double healthFactorPerLevel = (double)(maxHealth - baseHealth) / (double)this.getMaxExperienceLevel();
        if (healthFactorPerLevel > 0.0) {
            return (int)Math.floor((double)level * healthFactorPerLevel + 0.5);
        }
        return 0;
    }

    default public int getAttackDamageAdjustmentFromExperienceLevel(int level, int maxAttackDamage, int baseAttackDamage) {
        if (level == 1 || maxAttackDamage == 0 || baseAttackDamage >= maxAttackDamage) {
            return 0;
        }
        double attackDamageFactorPerLevel = (double)(maxAttackDamage - baseAttackDamage) / (double)this.getMaxExperienceLevel();
        if (attackDamageFactorPerLevel > 0.0) {
            return (int)Math.floor((double)level * attackDamageFactorPerLevel + 0.5);
        }
        return 0;
    }

    default public int getHealingAmountFromExperienceLevel(int level, int minHealing, int maxHealing) {
        if (level == 1 || minHealing >= maxHealing) {
            return minHealing;
        }
        double healingFactorPerLevel = (double)(maxHealing - minHealing) / (double)this.getMaxExperienceLevel();
        if (healingFactorPerLevel > 0.0) {
            return minHealing + (int)Math.floor((double)level * healingFactorPerLevel + 0.5);
        }
        return minHealing;
    }
}

