/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.container.CollectorCompanionMenu;
import de.markusbordihn.playercompanions.container.DefaultCompanionMenu;
import de.markusbordihn.playercompanions.container.FollowerCompanionMenu;
import de.markusbordihn.playercompanions.container.GuardCompanionMenu;
import de.markusbordihn.playercompanions.container.HealerCompanionMenu;
import de.markusbordihn.playercompanions.container.SupporterCompanionMenu;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionMenu {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");

    protected PlayerCompanionMenu() {
    }

    public static void openMenu(PlayerCompanionEntity playerCompanionEntity) {
        switch (playerCompanionEntity.getCompanionType()) {
            case COLLECTOR: {
                PlayerCompanionMenu.openCollectorMenu(playerCompanionEntity);
                break;
            }
            case FOLLOWER: {
                PlayerCompanionMenu.openFollowerMenu(playerCompanionEntity);
                break;
            }
            case GUARD: {
                PlayerCompanionMenu.openGuardMenu(playerCompanionEntity);
                break;
            }
            case HEALER: {
                PlayerCompanionMenu.openHealerMenu(playerCompanionEntity);
                break;
            }
            case SUPPORTER: {
                PlayerCompanionMenu.openSupporterMenu(playerCompanionEntity);
                break;
            }
            default: {
                PlayerCompanionMenu.openDefaultMenu(playerCompanionEntity);
            }
        }
    }

    public static void openDefaultMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Default Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new DefaultCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }

    public static void openCollectorMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Collector Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new CollectorCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }

    public static void openFollowerMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Follower Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new FollowerCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }

    public static void openGuardMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Guard Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new GuardCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }

    public static void openHealerMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Healer Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new HealerCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }

    public static void openSupporterMenu(PlayerCompanionEntity playerCompanionEntity) {
        ServerPlayer player;
        log.debug("Open Supporter Player Companion Menu for {} ...", (Object)playerCompanionEntity);
        LivingEntity owner = playerCompanionEntity.m_269323_();
        MinecraftServer minecraftServer = playerCompanionEntity.m_9236_().m_7654_();
        if (owner != null && minecraftServer != null && PlayerCompanionsServerData.available() && (player = minecraftServer.m_6846_().m_11259_(owner.m_20148_())) instanceof ServerPlayer) {
            final UUID playerCompanionUUID = playerCompanionEntity.m_20148_();
            final Component playerCompanionName = playerCompanionEntity.m_7770_();
            MenuProvider provider = new MenuProvider(){

                public Component m_5446_() {
                    return playerCompanionName;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                    return new SupporterCompanionMenu(windowId, inventory, playerCompanionUUID);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> buffer.m_130077_(playerCompanionUUID));
        }
    }
}

