/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import com.google.common.collect.Sets;
import de.markusbordihn.playercompanions.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PlayerCompanionNames {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Random rand = new Random();
    private static List<String> namesNPCFemale = new ArrayList<String>(List.of("Unnamed female NPC"));
    private static List<String> namesNPCMale = new ArrayList<String>(List.of("Unnamed male NPC"));
    private static List<String> namesNPCMisc = new ArrayList<String>(List.of("Unnamed misc NPC"));
    private static List<String> namesCompanionFemale = new ArrayList<String>(List.of("Unnamed female companion"));
    private static List<String> namesCompanionMale = new ArrayList<String>(List.of("Unnamed male companion"));
    private static List<String> namesCompanionMisc = new ArrayList<String>(List.of("Unnamed misc companion"));

    protected PlayerCompanionNames() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if (!((List)PlayerCompanionNames.COMMON.namesNPCFemale.get()).isEmpty()) {
            log.info("Loading about {} female NPC names ...", (Object)((List)PlayerCompanionNames.COMMON.namesNPCFemale.get()).size());
            namesNPCFemale = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesNPCFemale.get())));
        }
        if (!((List)PlayerCompanionNames.COMMON.namesNPCMale.get()).isEmpty()) {
            log.info("Loading about {} male NPC names ...", (Object)((List)PlayerCompanionNames.COMMON.namesNPCMale.get()).size());
            namesNPCMale = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesNPCMale.get())));
        }
        if (!((List)PlayerCompanionNames.COMMON.namesNPCMisc.get()).isEmpty()) {
            log.info("Loading about {} misc NPC names ...", (Object)((List)PlayerCompanionNames.COMMON.namesNPCMisc.get()).size());
            namesNPCMisc = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesNPCMisc.get())));
        }
        if (!((List)PlayerCompanionNames.COMMON.namesCompanionFemale.get()).isEmpty()) {
            log.info("Loading about {} female companion names ...", (Object)((List)PlayerCompanionNames.COMMON.namesCompanionFemale.get()).size());
            namesCompanionFemale = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesCompanionFemale.get())));
        }
        if (!((List)PlayerCompanionNames.COMMON.namesCompanionMale.get()).isEmpty()) {
            log.info("Loading about {} male companion names ...", (Object)((List)PlayerCompanionNames.COMMON.namesCompanionMale.get()).size());
            namesCompanionMale = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesCompanionMale.get())));
        }
        if (!((List)PlayerCompanionNames.COMMON.namesCompanionMisc.get()).isEmpty()) {
            log.info("Loading about {} misc companion names ...", (Object)((List)PlayerCompanionNames.COMMON.namesCompanionMisc.get()).size());
            namesCompanionMisc = new ArrayList<String>(Sets.newHashSet((Iterable)((Iterable)PlayerCompanionNames.COMMON.namesCompanionMisc.get())));
        }
    }

    public static String getRandomFemaleNpcName() {
        return namesNPCFemale.get(rand.nextInt(0, namesNPCFemale.size()));
    }

    public static String getRandomMaleNpcName() {
        return namesNPCMale.get(rand.nextInt(0, namesNPCMale.size()));
    }

    public static String getRandomMiscNpcName() {
        return namesNPCMisc.get(rand.nextInt(0, namesNPCMisc.size()));
    }

    public static String getRandomCompanionName() {
        int pool = rand.nextInt(0, 3);
        if (pool == 0) {
            return PlayerCompanionNames.getRandomMaleCompanionName();
        }
        if (pool == 1) {
            return PlayerCompanionNames.getRandomFemaleCompanionName();
        }
        return PlayerCompanionNames.getRandomMiscCompanionName();
    }

    public static String getRandomFemaleCompanionName() {
        return namesCompanionFemale.get(rand.nextInt(0, namesCompanionFemale.size()));
    }

    public static String getRandomMaleCompanionName() {
        return namesCompanionMale.get(rand.nextInt(0, namesCompanionMale.size()));
    }

    public static String getRandomMiscCompanionName() {
        return namesCompanionMisc.get(rand.nextInt(0, namesCompanionMisc.size()));
    }

    public static String getRandomFemaleAndMiscCompanionName() {
        int pool = rand.nextInt(0, 2);
        if (pool == 0) {
            return PlayerCompanionNames.getRandomMiscCompanionName();
        }
        return PlayerCompanionNames.getRandomFemaleCompanionName();
    }

    public static String getRandomMaleAndMiscCompanionName() {
        int pool = rand.nextInt(0, 2);
        if (pool == 0) {
            return PlayerCompanionNames.getRandomMiscCompanionName();
        }
        return PlayerCompanionNames.getRandomMaleCompanionName();
    }
}

