/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.data.PlayerCompanionsServerData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionSpawnManager {
    public static final String COMPANION_UUID_TAG = "CompanionUUID";
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final String FALL_DISTANCE_TAG = "FallDistance";
    private static final String FIRE_TAG = "Fire";
    private static final String HEALTH_TAG = "Health";
    private static final String MOTION_TAG = "Motion";
    private static final String ON_GROUND_TAG = "OnGround";

    protected PlayerCompanionSpawnManager() {
    }

    public static boolean spawn(UUID uuid, ServerPlayer serverPlayer) {
        return PlayerCompanionSpawnManager.spawn(uuid, serverPlayer, serverPlayer.m_9236_());
    }

    public static boolean spawn(UUID uuid, ServerPlayer serverPlayer, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return PlayerCompanionSpawnManager.spawn(uuid, serverPlayer, serverLevel, serverPlayer.m_20097_().m_7494_());
        }
        return false;
    }

    public static boolean spawn(UUID uuid, ServerPlayer serverPlayer, ServerLevel serverLevel) {
        return PlayerCompanionSpawnManager.spawn(uuid, serverPlayer, serverLevel, serverPlayer.m_20097_().m_7494_());
    }

    public static boolean spawn(ItemStack itemStack, ServerPlayer serverPlayer, ServerLevel serverLevel, BlockPos blockPos) {
        return PlayerCompanionSpawnManager.spawn(PlayerCompanionSpawnManager.getCompanionUUID(itemStack), serverPlayer, serverLevel, blockPos);
    }

    public static boolean spawn(UUID uuid, ServerPlayer serverPlayer, ServerLevel serverLevel, BlockPos blockPos) {
        log.info("Spawn {} {} {} {}", (Object)uuid, (Object)blockPos, (Object)serverPlayer, (Object)serverLevel);
        if (uuid == null) {
            log.error("Unable to find companion with UUID {} for player {} in {}.", (Object)uuid, (Object)serverPlayer, (Object)serverLevel);
            return false;
        }
        Entity playerCompanion = PlayerCompanionSpawnManager.getCompanionEntity(uuid, serverLevel);
        if (playerCompanion != null && playerCompanion.m_6084_()) {
            log.debug("Found existing player companion {}", (Object)playerCompanion);
        }
        PlayerCompanionSpawnManager.despawnCompanionExcept(uuid, serverLevel);
        if (playerCompanion != null && !playerCompanion.m_6084_()) {
            playerCompanion.m_142687_(Entity.RemovalReason.KILLED);
            playerCompanion = null;
        }
        if (playerCompanion != null && playerCompanion.m_6084_()) {
            if (playerCompanion.m_19950_((Entity)serverPlayer, 16.0)) {
                if (playerCompanion instanceof PlayerCompanionEntity) {
                    PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)playerCompanion;
                    playerCompanionEntity.setOrderedToPosition(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
                } else {
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"text.player_companions.companion_is_near_you", (Object[])new Object[]{playerCompanion.m_7755_()}));
                }
            } else {
                BlockState blockState = serverLevel.m_8055_(blockPos);
                if (PlayerCompanionSpawnManager.isValidSpawnPlace(blockState)) {
                    playerCompanion.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
                    log.debug("Teleport player companion {} to position ...", (Object)playerCompanion, (Object)blockPos);
                } else {
                    Vec3 playerPosition = serverPlayer.m_20182_();
                    playerCompanion.m_6021_(playerPosition.f_82479_, playerPosition.f_82480_, playerPosition.f_82481_);
                    log.debug("Teleport player companion {} to player ...", (Object)playerCompanion, (Object)serverPlayer);
                }
                return true;
            }
            return false;
        }
        Entity entity = PlayerCompanionSpawnManager.createCompanionEntity(uuid, serverLevel);
        if (entity != null) {
            BlockState blockState = serverLevel.m_8055_(blockPos);
            if (!PlayerCompanionSpawnManager.isValidSpawnPlace(blockState)) {
                blockPos = blockPos.m_7494_();
                blockState = serverLevel.m_8055_(blockPos);
            }
            if (PlayerCompanionSpawnManager.isValidSpawnPlace(blockState)) {
                entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                log.debug("Spawn player companion {} ...", (Object)entity);
                if (serverLevel.m_7967_(entity)) {
                    if (entity instanceof PlayerCompanionEntity) {
                        PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
                        playerCompanionEntity.finalizeSpawn();
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean despawn(UUID uuid, ServerLevel serverLevel) {
        Entity entity = PlayerCompanionSpawnManager.getCompanionEntity(uuid, serverLevel);
        if (entity instanceof PlayerCompanionEntity) {
            PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)entity;
            return PlayerCompanionSpawnManager.despawn((LivingEntity)playerCompanionEntity);
        }
        return false;
    }

    public static boolean despawn(LivingEntity livingEntity) {
        if (!(livingEntity instanceof PlayerCompanionEntity)) {
            return false;
        }
        PlayerCompanionEntity playerCompanionEntity = (PlayerCompanionEntity)livingEntity;
        PlayerCompanionData playerCompanionData = PlayerCompanionsServerData.get().updatePlayerCompanion(playerCompanionEntity);
        playerCompanionData.syncEntityData(livingEntity);
        log.debug("Despawn companion {} with {} ...", (Object)livingEntity, (Object)playerCompanionData);
        livingEntity.m_142467_(Entity.RemovalReason.DISCARDED);
        return true;
    }

    public static Entity getCompanionEntity(UUID uuid, ServerLevel serverLevel) {
        return uuid != null ? serverLevel.m_8791_(uuid) : null;
    }

    public static UUID getCompanionUUID(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128403_(COMPANION_UUID_TAG)) {
            return compoundTag.m_128342_(COMPANION_UUID_TAG);
        }
        return null;
    }

    public static void despawnCompanionExcept(UUID uuid, ServerLevel serverLevel) {
        MinecraftServer server = serverLevel.m_7654_();
        for (ServerLevel serverLevelToCheck : server.m_129785_()) {
            Entity playerCompanion;
            if (serverLevelToCheck == serverLevel || (playerCompanion = PlayerCompanionSpawnManager.getCompanionEntity(uuid, serverLevelToCheck)) == null) continue;
            playerCompanion.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    public static Entity createCompanionEntity(ItemStack itemStack, Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return PlayerCompanionSpawnManager.createCompanionEntity(itemStack, serverLevel);
        }
        return null;
    }

    public static Entity createCompanionEntity(ItemStack itemStack, ServerLevel serverLevel) {
        PlayerCompanionData playerCompanion = PlayerCompanionsServerData.get().getCompanion(itemStack);
        if (playerCompanion == null) {
            log.error("Unable to find player companion for item {}", (Object)itemStack);
            return null;
        }
        return PlayerCompanionSpawnManager.createCompanionEntity(playerCompanion, serverLevel);
    }

    public static Entity createCompanionEntity(UUID uuid, ServerLevel serverLevel) {
        PlayerCompanionData playerCompanion = PlayerCompanionsServerData.get().getCompanion(uuid);
        if (playerCompanion == null) {
            log.error("Unable to find player companion with UUID {}", (Object)uuid);
            return null;
        }
        return PlayerCompanionSpawnManager.createCompanionEntity(playerCompanion, serverLevel);
    }

    public static Entity createCompanionEntity(PlayerCompanionData playerCompanion, ServerLevel serverLevel) {
        EntityType<?> entityType = playerCompanion.getEntityType();
        CompoundTag entityData = playerCompanion.getEntityData();
        Entity entity = entityType.m_20615_((Level)serverLevel);
        if (entity != null && !entityData.m_128456_()) {
            if (entityData.m_128441_(HEALTH_TAG) && entityData.m_128457_(HEALTH_TAG) <= 0.0f) {
                entityData.m_128350_(HEALTH_TAG, playerCompanion.getEntityHealthMax());
            }
            if (entityData.m_128441_(FIRE_TAG) && entityData.m_128448_(FIRE_TAG) > 0) {
                entityData.m_128376_(FIRE_TAG, (short)0);
            }
            if (entityData.m_128441_(FALL_DISTANCE_TAG) && entityData.m_128457_(FALL_DISTANCE_TAG) > 0.0f) {
                entityData.m_128350_(FALL_DISTANCE_TAG, 0.0f);
            }
            if (entityData.m_128441_(MOTION_TAG)) {
                entityData.m_128365_(MOTION_TAG, (Tag)PlayerCompanionSpawnManager.newDoubleList(0.0, 0.0, 0.0));
            }
            if (entityData.m_128441_(ON_GROUND_TAG) && !entityData.m_128471_(ON_GROUND_TAG)) {
                entityData.m_128379_(ON_GROUND_TAG, true);
            }
            entity.m_20258_(entityData);
        }
        return entity;
    }

    public static boolean isValidSpawnPlace(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50125_) || blockState.m_60713_(Blocks.f_50035_);
    }

    private static ListTag newDoubleList(double ... values) {
        ListTag listTag = new ListTag();
        for (double value : values) {
            listTag.add((Object)DoubleTag.m_128500_((double)value));
        }
        return listTag;
    }
}

