/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerCompanionsFeatures {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    protected static final int EXPERIENCE_TICKER = 1200;
    protected static final int EXPERIENCE_OWNER_BONUS_TICKER = 6000;
    protected final Random random = new Random();
    protected final Level level;
    protected final PlayerCompanionEntity playerCompanionEntity;
    protected short ticker = 0;
    protected short experienceDistributeTicker = 0;
    protected short experienceOwnerBonusTicker = 0;
    protected int distributedExperience = 0;
    protected NeutralMob neutralMob;
    private float flap;
    private float flapSpeed;
    private float oFlapSpeed;
    private float oFlap;
    private float flapping = 1.0f;

    public PlayerCompanionsFeatures(PlayerCompanionEntity playerCompanionEntity, Level level) {
        this.level = level;
        this.playerCompanionEntity = playerCompanionEntity;
        if (playerCompanionEntity instanceof NeutralMob) {
            NeutralMob neutralMobCast;
            this.neutralMob = neutralMobCast = (NeutralMob)playerCompanionEntity;
        }
        this.ticker = (short)this.random.nextInt(0, 25);
        this.experienceDistributeTicker = 0;
    }

    public void distributeExperience(int experience) {
        if (experience > this.distributedExperience) {
            this.distributedExperience = experience;
        }
    }

    public void increaseExperience(int experience) {
        if (experience > 0) {
            this.playerCompanionEntity.increaseExperience(experience);
        }
    }

    public int getExperienceLevel() {
        return this.playerCompanionEntity.getExperienceLevel();
    }

    public LivingEntity getOwner() {
        return this.playerCompanionEntity.m_269323_();
    }

    public float getOFlap() {
        return this.oFlap;
    }

    public float getFlap() {
        return this.flap;
    }

    public float getOFlapSpeed() {
        return this.oFlapSpeed;
    }

    public float getFlapSpeed() {
        return this.flapSpeed;
    }

    protected void aiStep() {
    }

    public void aiFlappingStep() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.playerCompanionEntity.m_20096_() ? -1 : 4) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.playerCompanionEntity.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vec3 = this.playerCompanionEntity.m_20184_();
        if (!this.playerCompanionEntity.m_20096_() && vec3.f_82480_ < 0.0) {
            this.playerCompanionEntity.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected void tick() {
        if (!this.level.f_46443_) {
            short s = this.experienceOwnerBonusTicker;
            this.experienceOwnerBonusTicker = (short)(s + 1);
            if (s >= 6000 && this.distributedExperience == 0) {
                List playerEntities = this.level.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_(8.0), entity -> true);
                for (Player player : playerEntities) {
                    if (player != this.getOwner()) continue;
                    this.distributeExperience(1);
                    break;
                }
                this.experienceOwnerBonusTicker = 0;
            }
            short s2 = this.experienceDistributeTicker;
            this.experienceDistributeTicker = (short)(s2 + 1);
            if (s2 >= 1200) {
                this.increaseExperience(this.distributedExperience);
                this.distributedExperience = 0;
                this.experienceDistributeTicker = 0;
            }
        }
    }
}

