/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.ai.goal;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.ai.goal.PlayerCompanionGoal;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AvoidCreeperGoal
extends PlayerCompanionGoal {
    protected static final Predicate<LivingEntity> avoidPredicate = livingEntity -> true;
    protected static final Predicate<LivingEntity> predicateOnAvoidEntity = EntitySelector.f_20406_::test;
    protected final float maxDist;
    protected final PathNavigation pathNav;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    private final TargetingConditions avoidEntityTargeting;
    @Nullable
    protected Creeper creeperToAvoid;
    @Nullable
    protected Path path;

    public AvoidCreeperGoal(PlayerCompanionEntity playerCompanionEntity) {
        this(playerCompanionEntity, 5.0f, 1.0, 1.0);
    }

    public AvoidCreeperGoal(PlayerCompanionEntity playerCompanionEntity, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
        super(playerCompanionEntity);
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.pathNav = playerCompanionEntity.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDist).m_26888_(predicateOnAvoidEntity.and(avoidPredicate));
    }

    @Override
    public boolean m_8036_() {
        if (!this.playerCompanionEntity.hasOwnerAndIsAlive()) {
            return false;
        }
        this.creeperToAvoid = (Creeper)this.playerCompanionEntity.m_9236_().m_45982_(this.playerCompanionEntity.m_9236_().m_6443_(Creeper.class, this.playerCompanionEntity.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), creeper -> true), this.avoidEntityTargeting, (LivingEntity)this.playerCompanionEntity, this.playerCompanionEntity.m_20185_(), this.playerCompanionEntity.m_20186_(), this.playerCompanionEntity.m_20189_());
        if (this.creeperToAvoid == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.playerCompanionEntity, (int)16, (int)7, (Vec3)this.creeperToAvoid.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.creeperToAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.creeperToAvoid.m_20280_((Entity)this.playerCompanionEntity)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.creeperToAvoid = null;
    }

    public void m_8037_() {
        if (this.playerCompanionEntity.m_20280_((Entity)this.creeperToAvoid) < 49.0) {
            this.playerCompanionEntity.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.playerCompanionEntity.m_21573_().m_26517_(this.walkSpeedModifier);
        }
    }
}

