/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.ai.goal;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.ai.goal.PlayerCompanionGoal;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeAttackGoal
extends PlayerCompanionGoal {
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private final boolean canPenalize = false;
    private Path path;
    private double pathTargetX;
    private double pathTargetY;
    private double pathTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;

    public MeleeAttackGoal(PlayerCompanionEntity playerCompanionEntity, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        super(playerCompanionEntity);
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        long gameTime = this.playerCompanionEntity.m_9236_().m_46467_();
        if (gameTime - this.lastCanUseCheck < 20L || !this.playerCompanionEntity.shouldAttack()) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        if (!this.playerCompanionEntity.canAttack()) {
            return false;
        }
        LivingEntity livingEntity = this.playerCompanionEntity.m_5448_();
        this.path = this.playerCompanionEntity.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        if (livingEntity != null) {
            return this.getAttackReachSqr(livingEntity) >= this.playerCompanionEntity.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.playerCompanionEntity.m_5448_();
        if (!this.playerCompanionEntity.shouldAttack() || !this.playerCompanionEntity.canAttack()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.playerCompanionEntity.m_21573_().m_26571_();
        }
        return livingEntity == null || this.playerCompanionEntity.m_21444_(livingEntity.m_20183_());
    }

    public void m_8056_() {
        this.playerCompanionEntity.m_21573_().m_26536_(this.path, this.speedModifier);
        this.playerCompanionEntity.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.playerCompanionEntity.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.playerCompanionEntity.m_6710_(null);
        }
        this.playerCompanionEntity.m_21561_(false);
        this.playerCompanionEntity.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.playerCompanionEntity.m_5448_();
        if (livingEntity != null) {
            this.playerCompanionEntity.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double distance = this.playerCompanionEntity.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.playerCompanionEntity.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathTargetX == 0.0 && this.pathTargetY == 0.0 && this.pathTargetZ == 0.0 || livingEntity.m_20275_(this.pathTargetX, this.pathTargetY, this.pathTargetZ) >= 1.0 || this.playerCompanionEntity.m_217043_().m_188501_() < 0.05f)) {
                this.pathTargetX = livingEntity.m_20185_();
                this.pathTargetY = livingEntity.m_20186_();
                this.pathTargetZ = livingEntity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.playerCompanionEntity.m_217043_().m_188503_(7);
                Objects.requireNonNull(this);
                if (distance > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distance > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.playerCompanionEntity.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack(livingEntity, distance);
        }
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, double attackDistance) {
        double distance = this.getAttackReachSqr(livingEntity);
        if (attackDistance <= distance && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.playerCompanionEntity.m_6674_(InteractionHand.MAIN_HAND);
            this.playerCompanionEntity.m_7327_((Entity)livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }

    protected double getAttackReachSqr(LivingEntity livingEntity) {
        return this.playerCompanionEntity.m_20205_() * 2.0f * this.playerCompanionEntity.m_20205_() * 2.0f + livingEntity.m_20205_();
    }
}

