/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.ai.goal;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.ai.goal.PlayerCompanionGoal;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TameItemGoal
extends PlayerCompanionGoal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    private final double speedModifier;
    private final Ingredient items;
    private final boolean canScare;
    @Nullable
    protected Player player;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    private int calmDown;
    private boolean isRunning;

    public TameItemGoal(PlayerCompanionEntity playerCompanionEntity, double speedModifier) {
        super(playerCompanionEntity);
        this.speedModifier = speedModifier;
        this.items = Ingredient.m_43929_((ItemLike[])new ItemLike[]{playerCompanionEntity.getTameItem()});
        this.canScare = true;
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }

    @Override
    public boolean m_8036_() {
        if (!this.playerCompanionEntity.isTamable()) {
            return false;
        }
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.playerCompanionEntity.getNearestPlayer(this.targetingConditions);
        return this.player != null;
    }

    public boolean m_8045_() {
        Player nearestPlayer = this.player;
        if (!this.playerCompanionEntity.isTamable() || nearestPlayer == null) {
            return false;
        }
        if (this.canScare()) {
            if (this.playerCompanionEntity.m_20280_((Entity)nearestPlayer) < 36.0) {
                if (nearestPlayer.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)nearestPlayer.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)nearestPlayer.m_146908_() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = nearestPlayer.m_20185_();
                this.py = nearestPlayer.m_20186_();
                this.pz = nearestPlayer.m_20189_();
            }
            this.pRotX = nearestPlayer.m_146909_();
            this.pRotY = nearestPlayer.m_146908_();
        }
        return this.m_8036_();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void m_8056_() {
        Player nearestPlayer = this.player;
        if (nearestPlayer != null) {
            this.px = nearestPlayer.m_20185_();
            this.py = nearestPlayer.m_20186_();
            this.pz = nearestPlayer.m_20189_();
        }
        this.isRunning = true;
    }

    public void m_8041_() {
        this.player = null;
        this.playerCompanionEntity.m_21573_().m_26573_();
        this.calmDown = TameItemGoal.m_186073_((int)100);
        this.isRunning = false;
    }

    public void m_8037_() {
        this.playerCompanionEntity.m_21563_().m_24960_((Entity)this.player, (float)this.playerCompanionEntity.m_8085_() + 20.0f, (float)this.playerCompanionEntity.m_8132_());
        if (this.playerCompanionEntity.m_20280_((Entity)this.player) < 6.25) {
            this.playerCompanionEntity.m_21573_().m_26573_();
        } else {
            this.playerCompanionEntity.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

