/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.companions;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionNames;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.ai.goal.AvoidCreeperGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.FleeGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.MoveToPositionGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.RandomFlyAroundGoal;
import de.markusbordihn.playercompanions.entity.type.healer.HealerEntityFlyingAround;
import de.markusbordihn.playercompanions.item.ModItems;
import de.markusbordihn.playercompanions.sounds.ModSoundEvents;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Fairy
extends HealerEntityFlyingAround {
    public static final String ID = "fairy";
    public static final String NAME = "Fairy";
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42502_, Items.f_42572_});
    public static final List<PlayerCompanionVariant> VARIANTS = List.of(PlayerCompanionVariant.DEFAULT, PlayerCompanionVariant.BLUE, PlayerCompanionVariant.RED);
    private static final Map<PlayerCompanionVariant, Item> COMPANION_ITEM_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, (Item)ModItems.FAIRY_DEFAULT.get());
        hashMap.put(PlayerCompanionVariant.BLUE, (Item)ModItems.FAIRY_BLUE.get());
        hashMap.put(PlayerCompanionVariant.RED, (Item)ModItems.FAIRY_RED.get());
    });

    public Fairy(EntityType<? extends PlayerCompanionEntity> entityType, Level level) {
        super(entityType, level, COMPANION_ITEM_BY_VARIANT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FleeGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new MoveToPositionGoal(this, 1.0, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidCreeperGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomFlyAroundGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_26440_(true);
        flyingPathNavigation.m_7008_(true);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    @Override
    public void finalizeSpawn() {
        super.finalizeSpawn();
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (itemStack != null && itemStack.m_41619_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42589_));
        }
    }

    @Override
    public Item getTameItem() {
        return (Item)ModItems.TAME_CAKE.get();
    }

    @Override
    public Ingredient getFoodItems() {
        return FOOD_ITEMS;
    }

    @Override
    public String getRandomName() {
        return PlayerCompanionNames.getRandomFemaleCompanionName();
    }

    @Override
    public PlayerCompanionVariant getRandomVariant() {
        if (VARIANTS.size() > 1 && this.f_19796_.m_188503_(2) == 0) {
            return VARIANTS.get(this.f_19796_.m_188503_(VARIANTS.size()));
        }
        return PlayerCompanionVariant.DEFAULT;
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.f_123810_;
    }

    @Override
    public SoundEvent getPetSound() {
        return (SoundEvent)ModSoundEvents.COMPANION_FAIRY_HAGGLE.get();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.COMPANION_FAIRY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.COMPANION_FAIRY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.COMPANION_FAIRY_DEATH.get();
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.86f * this.m_20192_()), (double)(this.m_20205_() * 0.15f));
    }

    public float m_6134_() {
        return 0.4f;
    }

    @Override
    public boolean canSitOnShoulder() {
        return this.hasRideCooldown();
    }

    @Override
    public int getEntityGuiScaling() {
        return 65;
    }

    @Override
    public void onMainHandItemSlotChange(ItemStack itemStack) {
        this.setGlowInTheDark(itemStack.m_150930_(Items.f_42000_));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.increaseRideCooldownCounter();
    }
}

