/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.companions;

import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.ai.goal.AvoidCreeperGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.FleeGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.MoveToPositionGoal;
import de.markusbordihn.playercompanions.entity.type.collector.CollectorEntityWalking;
import de.markusbordihn.playercompanions.item.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Pig
extends CollectorEntityWalking {
    public static final String ID = "pig";
    public static final String NAME = "Pig";
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42620_, Items.f_42732_});
    public static final List<PlayerCompanionVariant> VARIANTS = List.of(PlayerCompanionVariant.DEFAULT, PlayerCompanionVariant.SPOTTED);
    protected static final Logger log = LogManager.getLogger((String)"Bo's Player Companions");
    private static final Map<PlayerCompanionVariant, Item> COMPANION_ITEM_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> {
        hashMap.put(PlayerCompanionVariant.DEFAULT, (Item)ModItems.PIG_DEFAULT.get());
        hashMap.put(PlayerCompanionVariant.SPOTTED, (Item)ModItems.PIG_SPOTTED.get());
    });

    public Pig(EntityType<? extends PlayerCompanionEntity> entityType, Level level) {
        super(entityType, level, COMPANION_ITEM_BY_VARIANT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FleeGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new MoveToPositionGoal(this, 0.5, 0.5f));
        this.f_21345_.m_25352_(2, (Goal)new AvoidCreeperGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public Item getTameItem() {
        return (Item)ModItems.TAME_CARROT.get();
    }

    @Override
    public Ingredient getFoodItems() {
        return FOOD_ITEMS;
    }

    @Override
    public PlayerCompanionVariant getRandomVariant() {
        if (VARIANTS.size() > 1 && this.f_19796_.m_188503_(2) == 0) {
            return VARIANTS.get(this.f_19796_.m_188503_(VARIANTS.size()));
        }
        return PlayerCompanionVariant.DEFAULT;
    }

    @Override
    public SoundEvent getPetSound() {
        return SoundEvents.f_12233_;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12233_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12235_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12234_;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.55f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.82f;
    }

    @Override
    public int getEntityGuiScaling() {
        return 35;
    }

    @Override
    public int getEntityGuiTop() {
        return 13;
    }
}

