/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.companions;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.ai.goal.FleeGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.MoveToPositionGoal;
import de.markusbordihn.playercompanions.entity.ai.goal.ShootLargeFireballGoal;
import de.markusbordihn.playercompanions.entity.type.guard.GuardEntityFlying;
import de.markusbordihn.playercompanions.item.ModItems;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class SmallGhast
extends GuardEntityFlying
implements NeutralMob {
    public static final String ID = "small_ghast";
    public static final String NAME = "Small Ghast";
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42500_});
    public static final List<PlayerCompanionVariant> VARIANTS = List.of(PlayerCompanionVariant.DEFAULT);
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Map<PlayerCompanionVariant, Item> COMPANION_ITEM_BY_VARIANT = (Map)Util.m_137469_(new EnumMap(PlayerCompanionVariant.class), hashMap -> hashMap.put(PlayerCompanionVariant.DEFAULT, (Item)ModItems.SMALL_GHAST_DEFAULT.get()));

    public SmallGhast(EntityType<? extends PlayerCompanionEntity> entityType, Level level) {
        super(entityType, level, COMPANION_ITEM_BY_VARIANT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkGhastSpawnRules(EntityType<SmallGhast> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && SmallGhast.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int angerTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)angerTime);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MoveToPositionGoal(this, 1.0, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new FleeGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 2.0f, true));
        this.f_21345_.m_25352_(7, (Goal)new SmallGhastLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new ShootLargeFireballGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SmallGhast)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    @Override
    public int getExplosionPower() {
        return (Integer)SmallGhast.COMMON.smallGhastExplosionPower.get();
    }

    @Override
    public boolean doPlayJumpSound() {
        return false;
    }

    @Override
    public Item getTameItem() {
        return (Item)ModItems.TAME_BONE.get();
    }

    @Override
    public Ingredient getFoodItems() {
        return FOOD_ITEMS;
    }

    @Override
    public PlayerCompanionVariant getRandomVariant() {
        if (VARIANTS.size() > 1 && this.f_19796_.m_188503_(2) == 0) {
            return VARIANTS.get(this.f_19796_.m_188503_(VARIANTS.size()));
        }
        return PlayerCompanionVariant.DEFAULT;
    }

    @Override
    public SoundEvent getPetSound() {
        return SoundEvents.f_11919_;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11921_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.72f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.35f;
    }

    public float m_6134_() {
        return 0.75f;
    }

    @Override
    public int getEntityGuiScaling() {
        return 50;
    }

    @Override
    public int getEntityGuiTop() {
        return 42;
    }

    static class SmallGhastLookGoal
    extends Goal {
        private final SmallGhast smallGhast;

        public SmallGhastLookGoal(SmallGhast smallGhast) {
            this.smallGhast = smallGhast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.smallGhast.m_5448_() == null) {
                Vec3 vec3 = this.smallGhast.m_20184_();
                this.smallGhast.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.smallGhast.f_20883_ = this.smallGhast.m_146908_();
            } else {
                LivingEntity livingEntity = this.smallGhast.m_5448_();
                if (livingEntity != null && livingEntity.m_20280_((Entity)this.smallGhast) < 4096.0) {
                    double d1 = livingEntity.m_20185_() - this.smallGhast.m_20185_();
                    double d2 = livingEntity.m_20189_() - this.smallGhast.m_20189_();
                    this.smallGhast.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.smallGhast.f_20883_ = this.smallGhast.m_146908_();
                }
            }
        }
    }
}

