/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.type.collector;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.data.PlayerCompanionData;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionsFeatures;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CollectorFeatures
extends PlayerCompanionsFeatures {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final short COLLECT_TICK = 60;

    public CollectorFeatures(PlayerCompanionEntity playerCompanionEntity, Level level) {
        super(playerCompanionEntity, level);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if ((Integer)CollectorFeatures.COMMON.collectorTypeRadius.get() > 0) {
            log.info("{} Collector will automatically collect items in a {} block radius.", (Object)"\ud83d\udc7e", CollectorFeatures.COMMON.collectorTypeRadius.get());
        } else {
            log.info("{} Collector will not automatically collect items!", (Object)"\ud83d\udc7e");
        }
    }

    private void collectorTick() {
        if (!this.level.f_46443_ && (Integer)CollectorFeatures.COMMON.collectorTypeRadius.get() > 0) {
            short s = this.ticker;
            this.ticker = (short)(s + 1);
            if (s >= 60) {
                PlayerCompanionData companionData;
                List itemEntities = this.level.m_142425_((EntityTypeTest)EntityType.f_20461_, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)CollectorFeatures.COMMON.collectorTypeRadius.get()).intValue()), entity -> true);
                if (!itemEntities.isEmpty() && (companionData = this.playerCompanionEntity.getData()) != null) {
                    boolean hasCollectSomething = false;
                    for (ItemEntity itemEntity : itemEntities) {
                        if (!itemEntity.m_6084_() || !companionData.storeInventoryItem(itemEntity.m_32055_())) continue;
                        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                        hasCollectSomething = true;
                    }
                    if (hasCollectSomething) {
                        this.distributeExperience(1);
                    }
                }
                this.ticker = 0;
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.collectorTick();
    }
}

