/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.type.follower;

import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntityJumping;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionTypeIcon;
import de.markusbordihn.playercompanions.entity.type.follower.FollowerFeatures;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FollowerEntityJumping
extends PlayerCompanionEntityJumping {
    private static final Set<AggressionLevel> AGGRESSION_LEVELS = EnumSet.of(AggressionLevel.PASSIVE_FLEE, AggressionLevel.PASSIVE);
    protected final FollowerFeatures followerFeatures;

    public FollowerEntityJumping(EntityType<? extends PlayerCompanionEntity> entityType, Level level, Map<PlayerCompanionVariant, Item> companionItemByVariant) {
        super(entityType, level, companionItemByVariant);
        this.setAggressionLevel(this.getDefaultAggressionLevel());
        this.followerFeatures = new FollowerFeatures(this, level);
    }

    @Override
    public Set<AggressionLevel> getAggressionLevels() {
        return AGGRESSION_LEVELS;
    }

    @Override
    public AggressionLevel getDefaultAggressionLevel() {
        return AggressionLevel.PASSIVE;
    }

    @Override
    public AggressionLevel getFirstAggressionLevel() {
        return AggressionLevel.PASSIVE_FLEE;
    }

    @Override
    public AggressionLevel getLastAggressionLevel() {
        return AggressionLevel.PASSIVE;
    }

    @Override
    public PlayerCompanionType getCompanionType() {
        return PlayerCompanionType.FOLLOWER;
    }

    @Override
    public ItemStack getCompanionTypeIcon() {
        return PlayerCompanionTypeIcon.FOLLOWER;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.followerFeatures.tick();
    }
}

