/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.type.guard;

import de.markusbordihn.playercompanions.entity.AggressionLevel;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntityWalking;
import de.markusbordihn.playercompanions.entity.PlayerCompanionVariant;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionTypeIcon;
import de.markusbordihn.playercompanions.entity.type.guard.GuardFeatures;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GuardEntityWalking
extends PlayerCompanionEntityWalking {
    private static final Set<AggressionLevel> AGGRESSION_LEVELS = EnumSet.of(AggressionLevel.PASSIVE_FLEE, new AggressionLevel[]{AggressionLevel.PASSIVE, AggressionLevel.NEUTRAL, AggressionLevel.AGGRESSIVE, AggressionLevel.AGGRESSIVE_MONSTER, AggressionLevel.AGGRESSIVE_ANIMALS, AggressionLevel.AGGRESSIVE_PLAYERS});
    protected final GuardFeatures guardFeatures;

    public GuardEntityWalking(EntityType<? extends PlayerCompanionEntity> entityType, Level level, Map<PlayerCompanionVariant, Item> companionItemByVariant) {
        super(entityType, level, companionItemByVariant);
        this.setAggressionLevel(this.getDefaultAggressionLevel());
        this.guardFeatures = new GuardFeatures(this, level);
    }

    @Override
    public Set<AggressionLevel> getAggressionLevels() {
        return AGGRESSION_LEVELS;
    }

    @Override
    public AggressionLevel getDefaultAggressionLevel() {
        return AggressionLevel.NEUTRAL;
    }

    @Override
    public AggressionLevel getFirstAggressionLevel() {
        return AggressionLevel.PASSIVE_FLEE;
    }

    @Override
    public AggressionLevel getLastAggressionLevel() {
        return AggressionLevel.AGGRESSIVE_PLAYERS;
    }

    @Override
    public PlayerCompanionType getCompanionType() {
        return PlayerCompanionType.GUARD;
    }

    @Override
    public ItemStack getCompanionTypeIcon() {
        return PlayerCompanionTypeIcon.GUARD;
    }

    public void m_8107_() {
        super.m_8107_();
        this.guardFeatures.aiStep();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.guardFeatures.tick();
    }
}

