/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.type.healer;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionsFeatures;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HealerFeatures
extends PlayerCompanionsFeatures {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final short HEALER_TICK = 40;
    private static final int PARTICLE_FRAMES = 3;

    protected HealerFeatures(PlayerCompanionEntity playerCompanionEntity, Level level) {
        super(playerCompanionEntity, level);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if ((Integer)HealerFeatures.COMMON.healerTypeRadius.get() > 0 && (Integer)HealerFeatures.COMMON.healerTypeMinAmount.get() < (Integer)HealerFeatures.COMMON.healerTypeMaxAmount.get()) {
            log.info("{} Healer will automatically heal between {} - {} hp in a {} block radius.", (Object)"\ud83d\udc7e", HealerFeatures.COMMON.healerTypeMinAmount.get(), HealerFeatures.COMMON.healerTypeMaxAmount.get(), HealerFeatures.COMMON.healerTypeRadius.get());
        } else {
            log.info("{} Healer will not automatically heal!", (Object)"\ud83d\udc7e");
        }
    }

    private void healerTick() {
        if ((Integer)HealerFeatures.COMMON.healerTypeRadius.get() > 0) {
            short s = this.ticker;
            this.ticker = (short)(s + 1);
            if (s >= 40) {
                boolean hasHealthSomething;
                boolean bl = hasHealthSomething = this.getOwner() != null && this.healEntity(this.level, this.getOwner());
                if (!hasHealthSomething && this.healEntity(this.level, (LivingEntity)this.playerCompanionEntity)) {
                    hasHealthSomething = true;
                }
                if (!hasHealthSomething) {
                    List playerEntities = this.level.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)HealerFeatures.COMMON.healerTypeRadius.get()).intValue()), entity -> true);
                    for (Player player : playerEntities) {
                        if (player == this.getOwner() || !this.healEntity(this.level, (LivingEntity)player)) continue;
                        hasHealthSomething = true;
                        break;
                    }
                }
                if (!hasHealthSomething && this.getOwner() != null) {
                    List tamableAnimals = this.playerCompanionEntity.m_9236_().m_6443_(TamableAnimal.class, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)HealerFeatures.COMMON.healerTypeRadius.get()).intValue()), entity -> true);
                    for (TamableAnimal tamableAnimal : tamableAnimals) {
                        if (tamableAnimal == this.playerCompanionEntity || tamableAnimal.m_269323_() != this.getOwner() || !this.healEntity(this.level, (LivingEntity)tamableAnimal)) continue;
                        hasHealthSomething = true;
                        break;
                    }
                }
                if (hasHealthSomething && !this.level.f_46443_) {
                    this.distributeExperience(1);
                }
                this.ticker = 0;
            }
        }
    }

    public boolean healEntity(Level level, LivingEntity livingEntity) {
        if (!livingEntity.m_6084_() || livingEntity.m_21223_() >= livingEntity.m_21233_()) {
            return false;
        }
        if (!level.f_46443_) {
            int healingAmount = this.playerCompanionEntity.getHealingAmountFromExperienceLevel(this.getExperienceLevel(), (Integer)HealerFeatures.COMMON.healerTypeMinAmount.get(), (Integer)HealerFeatures.COMMON.healerTypeMaxAmount.get());
            livingEntity.m_5634_((float)healingAmount);
            return true;
        }
        this.healAnimation(livingEntity, level);
        return false;
    }

    public void healAnimation(LivingEntity livingEntity, Level level) {
        if (!level.f_46443_ || livingEntity == null) {
            return;
        }
        double targetX = livingEntity.m_20185_() + 0.5;
        double targetY = livingEntity.m_20186_() + 0.5;
        double targetZ = livingEntity.m_20189_() + 0.5;
        for (int i = 0; i < 3; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, targetX, targetY, targetZ, 1.0, 1.0, 1.0);
        }
        if (livingEntity == this.playerCompanionEntity) {
            return;
        }
        double x = this.playerCompanionEntity.m_20185_() + 0.5;
        double y = this.playerCompanionEntity.m_20186_() + 0.5;
        double z = this.playerCompanionEntity.m_20189_() + 0.5;
        double targetXRatio = (targetX - x) / 3.0;
        double targetYRatio = (targetY - y) / 3.0;
        double targetZRatio = (targetZ - z) / 3.0;
        for (int i = 0; i < 3; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123750_, x += targetXRatio, y += targetYRatio, z += targetZRatio, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.healerTick();
    }
}

