/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.playercompanions.entity.type.supporter;

import de.markusbordihn.playercompanions.config.CommonConfig;
import de.markusbordihn.playercompanions.entity.PlayerCompanionEntity;
import de.markusbordihn.playercompanions.entity.PlayerCompanionsFeatures;
import de.markusbordihn.playercompanions.entity.type.PlayerCompanionType;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SupporterFeatures
extends PlayerCompanionsFeatures {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final short SUPPORTER_TICK = 180;

    protected SupporterFeatures(PlayerCompanionEntity playerCompanionEntity, Level level) {
        super(playerCompanionEntity, level);
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        if ((Integer)SupporterFeatures.COMMON.supporterTypeRadius.get() > 0) {
            log.info("{} Supporter will automatically buff in a {} block radius.", (Object)"\ud83d\udc7e", SupporterFeatures.COMMON.supporterTypeRadius.get());
        } else {
            log.info("{} Supporter will not automatically buff!", (Object)"\ud83d\udc7e");
        }
    }

    private void supporterTick() {
        if (!this.level.f_46443_ && (Integer)SupporterFeatures.COMMON.supporterTypeRadius.get() > 0) {
            short s = this.ticker;
            this.ticker = (short)(s + 1);
            if (s >= 180) {
                boolean hasBuffSomething;
                boolean bl = hasBuffSomething = this.getOwner() != null && this.buffLivingEntity(this.getOwner());
                if (!hasBuffSomething && this.buffLivingEntity((LivingEntity)this.playerCompanionEntity)) {
                    hasBuffSomething = true;
                }
                if (!hasBuffSomething) {
                    List playerEntities = this.level.m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)SupporterFeatures.COMMON.supporterTypeRadius.get()).intValue()), entity -> true);
                    for (Player player : playerEntities) {
                        if (player == this.getOwner() || !this.buffLivingEntity((LivingEntity)player)) continue;
                        hasBuffSomething = true;
                        break;
                    }
                }
                if (!hasBuffSomething && this.getOwner() != null) {
                    List playerCompanions = this.playerCompanionEntity.m_9236_().m_6443_(PlayerCompanionEntity.class, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)SupporterFeatures.COMMON.supporterTypeRadius.get()).intValue()), entity -> true);
                    for (PlayerCompanionEntity playerCompanion : playerCompanions) {
                        if (playerCompanion == this.playerCompanionEntity || playerCompanion.getCompanionType() != PlayerCompanionType.HEALER || playerCompanion.m_269323_() != this.getOwner() || !this.buffLivingEntity((LivingEntity)playerCompanion)) continue;
                        hasBuffSomething = true;
                        break;
                    }
                }
                if (!hasBuffSomething && this.getOwner() != null) {
                    List tamableAnimals = this.playerCompanionEntity.m_9236_().m_6443_(TamableAnimal.class, new AABB(this.playerCompanionEntity.m_20183_()).m_82400_((double)((Integer)SupporterFeatures.COMMON.supporterTypeRadius.get()).intValue()), entity -> true);
                    for (TamableAnimal tamableAnimal : tamableAnimals) {
                        if (tamableAnimal == this.playerCompanionEntity || tamableAnimal.m_269323_() != this.getOwner() || !this.buffLivingEntity((LivingEntity)tamableAnimal)) continue;
                        hasBuffSomething = true;
                        break;
                    }
                }
                if (hasBuffSomething) {
                    this.distributeExperience(1);
                }
                this.ticker = 0;
            }
        }
    }

    public boolean buffLivingEntity(LivingEntity livingEntity) {
        if (!livingEntity.m_6084_()) {
            return false;
        }
        boolean level1Buff = false;
        boolean level5Buff = false;
        boolean level10Buff = false;
        boolean level20Buff = false;
        level1Buff = this.buffLivingEntityDamageResistance(livingEntity);
        if (this.getExperienceLevel() >= 5) {
            level5Buff = this.buffLivingEntityDamageBoost(livingEntity);
        }
        if (this.getExperienceLevel() >= 20) {
            level20Buff = this.buffLivingEntityFireResistance(livingEntity);
        }
        return level1Buff || level5Buff || level10Buff || level20Buff;
    }

    public boolean buffLivingEntityDamageBoost(LivingEntity livingEntity) {
        if ((Integer)SupporterFeatures.COMMON.supporterTypeDamageBoostDuration.get() > 0 && !livingEntity.m_21023_(MobEffects.f_19600_)) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, ((Integer)SupporterFeatures.COMMON.supporterTypeDamageBoostDuration.get()).intValue(), 0, false, false, true));
            return true;
        }
        return false;
    }

    public boolean buffLivingEntityDamageResistance(LivingEntity livingEntity) {
        if ((Integer)SupporterFeatures.COMMON.supporterTypeDamageResistanceDuration.get() > 0 && !livingEntity.m_21023_(MobEffects.f_19606_)) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, ((Integer)SupporterFeatures.COMMON.supporterTypeDamageResistanceDuration.get()).intValue(), 0, false, false, true));
            return true;
        }
        return false;
    }

    public boolean buffLivingEntityFireResistance(LivingEntity livingEntity) {
        if ((Integer)SupporterFeatures.COMMON.supporterTypeFireResistanceDuration.get() > 0 && !livingEntity.m_21023_(MobEffects.f_19607_)) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, ((Integer)SupporterFeatures.COMMON.supporterTypeFireResistanceDuration.get()).intValue(), 0, false, false, true));
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        this.supporterTick();
    }
}

